/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.entityviewdistance.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.entityviewdistance.EVDMod;
import eu.pb4.entityviewdistance.config.Config;
import eu.pb4.entityviewdistance.config.data.ConfigData;
import eu.pb4.entityviewdistance.config.data.VersionConfigData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;

public class ConfigManager {
    public static final int VERSION = 1;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    private static Config CONFIG;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean loadConfig() {
        CONFIG = null;
        try {
            ConfigData config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "entity-view-distance.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));
                VersionConfigData versionConfigData = (VersionConfigData)GSON.fromJson(json, VersionConfigData.class);
                switch (versionConfigData.CONFIG_VERSION_DONT_TOUCH_THIS) {
                    default: 
                }
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
            } else {
                config = new ConfigData();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
            writer.write(GSON.toJson((Object)config));
            writer.close();
            CONFIG = new Config(config);
            return true;
        }
        catch (IOException exception) {
            EVDMod.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
            CONFIG = new Config(new ConfigData());
            return false;
        }
    }

    public static void overrideConfig() {
        ConfigManager.overrideConfig(CONFIG.toConfigData());
    }

    public static void overrideConfig(ConfigData configData) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "entity-view-distance.json");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)configData));
            writer.close();
            CONFIG = new Config(configData);
        }
        catch (Exception e) {
            EVDMod.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }
}

