/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class Storage {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LStorage:\u00a7r\u00a7f\nCalculates the number of needed item sorters given a rate of items per hour \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f. Additional input for multiple times hopper speed sorters.\n        \u00a7eUsage: /calc storage <itemsperhour>\n        Usage: /calc storage <timesHopperSpeed> <itemsperhour>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"storage").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"timesHopperSpeed", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), String.valueOf(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timesHopperSpeed")), 1);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })).then(ClientCommandManager.argument((String)"itemsperhour", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"itemsperhour"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timesHopperSpeed"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.argument((String)"itemsperhour", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"itemsperhour"), 1);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("storage");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"storage").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"timesHopperSpeed", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((class_2168)ctx.getSource()).method_9228(), String.valueOf(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timesHopperSpeed")), 1);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })).then(class_2170.method_9244((String)"itemsperhour", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"itemsperhour"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"timesHopperSpeed"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9244((String)"itemsperhour", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Storage.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"itemsperhour"), 1);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("storage");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String itemsperhour, int timesHopperSpeed) {
        double rates = CalcCommand.getParsedExpression(player, itemsperhour, new Integer[0]);
        double hopperSpeed = 9000 * timesHopperSpeed;
        double sorters = Math.ceil(rates / hopperSpeed);
        double sbsperhour = rates * 1.0 / 1728.0;
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Required ", "input", "xHopper speed \u00a77(9,000/hr)\u00a7f sorters for ", "input", " items/hr = ", "result", " \nSBs/hr = ", "result"}, new String[]{nf.format(timesHopperSpeed), itemsperhour}, new String[]{nf.format(sorters), nf.format(sbsperhour)});
        return message;
    }
}

