/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class SecondsToRepeater {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LSeconds to Repeater:\u00a7r\u00a7f\n    Given a number of seconds \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the number of repeaters and their delay.\n    \u00a7eUsage: /calc secondstorepeater <seconds>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"secondstorepeater").then(ClientCommandManager.argument((String)"seconds", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = SecondsToRepeater.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"seconds"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("secondstorepeater");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"secondstorepeater").then(class_2170.method_9244((String)"seconds", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = SecondsToRepeater.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"seconds"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("secondstorepeater");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String seconds) {
        double secondsDouble = CalcCommand.getParsedExpression(player, seconds, new Integer[0]);
        double ticks = secondsDouble * 10.0;
        double repeaters = Math.ceil(ticks / 4.0);
        if (ticks % 4.0 != 0.0) {
            CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Repeaters required for ", "input", " seconds = ", "result", " \nLast repeater tick = ", "result"}, new String[]{seconds}, new String[]{nf.format(repeaters), nf.format(ticks % 4.0)});
            return message;
        }
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Repeaters required for ", "input", " seconds = ", "result"}, new String[]{seconds}, new String[]{nf.format(repeaters)});
        return message;
    }
}

