/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.CalcMod;
import net.jsa2025.calcmod.commands.subcommands.AllayStorage;
import net.jsa2025.calcmod.commands.subcommands.Basic;
import net.jsa2025.calcmod.commands.subcommands.Craft;
import net.jsa2025.calcmod.commands.subcommands.Custom;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.commands.subcommands.ItemToSb;
import net.jsa2025.calcmod.commands.subcommands.ItemToStack;
import net.jsa2025.calcmod.commands.subcommands.Nether;
import net.jsa2025.calcmod.commands.subcommands.Overworld;
import net.jsa2025.calcmod.commands.subcommands.Piglin;
import net.jsa2025.calcmod.commands.subcommands.Random;
import net.jsa2025.calcmod.commands.subcommands.Rates;
import net.jsa2025.calcmod.commands.subcommands.SbToItem;
import net.jsa2025.calcmod.commands.subcommands.SecondsToHopperClock;
import net.jsa2025.calcmod.commands.subcommands.SecondsToRepeater;
import net.jsa2025.calcmod.commands.subcommands.SignalToItems;
import net.jsa2025.calcmod.commands.subcommands.StackToItem;
import net.jsa2025.calcmod.commands.subcommands.Storage;
import net.jsa2025.calcmod.commands.subcommands.Variables;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

public class CalcCommand {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registry) {
        LiteralArgumentBuilder<FabricClientCommandSource> command = ClientCommandManager.literal((String)"calc");
        command = Basic.register(command);
        command = Storage.register(command);
        command = Nether.register(command);
        command = Overworld.register(command);
        command = SbToItem.register(command);
        command = ItemToSb.register(command);
        command = SecondsToHopperClock.register(command);
        command = SecondsToRepeater.register(command);
        command = ItemToStack.register(command);
        command = StackToItem.register(command);
        command = Rates.register(command);
        command = AllayStorage.register(command);
        command = Random.register(command);
        command = Craft.register(command, registry);
        command = SignalToItems.register(command);
        command = Piglin.register(command);
        command = Custom.register(command);
        command = Variables.register(command);
        command = Help.register(command);
        dispatcher.register(command);
    }

    public static void registerServer(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 env) {
        LiteralArgumentBuilder<class_2168> command = class_2170.method_9247((String)"calc");
        Basic.registerServer(command);
        command = Storage.registerServer(command);
        command = Nether.registerServer(command);
        command = Overworld.registerServer(command);
        command = SbToItem.registerServer(command);
        command = ItemToSb.registerServer(command);
        command = SecondsToHopperClock.registerServer(command);
        command = SecondsToRepeater.registerServer(command);
        command = ItemToStack.registerServer(command);
        command = StackToItem.registerServer(command);
        command = Rates.registerServer(command);
        command = AllayStorage.registerServer(command);
        command = Random.registerServer(command);
        command = Craft.registerServer(command, registry);
        command = SignalToItems.registerServer(command);
        command = Piglin.registerServer(command);
        command = Custom.registerServer(command);
        command = Variables.registerServer(command);
        command = Help.registerServer(command);
        dispatcher.register(command);
    }

    public static double getParsedExpression(class_1297 player, String in, Integer ... nonstackable) {
        int stackSize = nonstackable.length == 0 ? 64 : nonstackable[0];
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("dub64", 3456.0);
        vars.put("dub16", 864.0);
        vars.put("dub1", 54.0);
        vars.put("sb64", 1728.0);
        vars.put("sb16", 432.0);
        vars.put("sb1", 27.0);
        vars.put("stack64", 64.0);
        vars.put("stack16", 16.0);
        vars.put("stack1", 1.0);
        vars.put("min", 60.0);
        vars.put("hour", 3600.0);
        if (Objects.nonNull(player)) {
            vars.put("x", Double.valueOf(player.method_24515().method_10263()));
            vars.put("y", Double.valueOf(player.method_24515().method_10263()));
            vars.put("z", Double.valueOf(player.method_24515().method_10260()));
            vars.put("health", Double.valueOf(((class_1657)player).method_6032()));
        }
        vars.put("dub", (Double)vars.get("dub" + stackSize));
        vars.put("sb", (Double)vars.get("sb" + stackSize));
        vars.put("stack", (Double)vars.get("stack" + stackSize));
        String withVars = in;
        ArrayList<String> parsedCustomFunctions = Custom.getParsedFunctions();
        parsedCustomFunctions.sort((s1, s2) -> s2.length() - s1.length());
        for (int f = 0; f < parsedCustomFunctions.size(); ++f) {
            String func = parsedCustomFunctions.get(f);
            withVars = withVars.replaceAll(func.split("[(]")[0], "{" + f + "}");
        }
        ArrayList<Function> primitiveElements = new ArrayList<Function>();
        for (String key : vars.keySet()) {
            for (int f = 0; f < parsedCustomFunctions.size(); ++f) {
                String func = parsedCustomFunctions.get(f);
                String expression = func.split("= ")[1].replaceAll(key, "(" + vars.get(key) + ")");
                if (CalcCommand.contains(func.split(" =")[0].split("[(]")[1].replace("[)]", "").split(","), key)) continue;
                parsedCustomFunctions.set(f, func.split("= ")[0] + "= " + expression);
            }
            withVars = withVars.replaceAll(key, "(" + vars.get(key) + ")");
        }
        withVars = withVars.replaceAll("(\\d*),(\\d+)", "$1$2");
        for (int f = 0; f < parsedCustomFunctions.size(); ++f) {
            withVars = withVars.replaceAll("[{]" + f + "[}]", parsedCustomFunctions.get(f).split("[(]")[0]);
            primitiveElements.add(new Function(parsedCustomFunctions.get(f), new PrimitiveElement[0]));
        }
        CalcMod.LOGGER.info("Parsed " + withVars);
        return new Expression(withVars, primitiveElements.toArray(new PrimitiveElement[0])).calculate();
    }

    static boolean contains(String[] array, String value) {
        for (String str : array) {
            if (!str.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String getParsedStack(double items, int stacksize) {
        if (items >= 64.0) {
            return "Stacks: " + nf.format(Math.floor(items / (double)stacksize)) + ", Items: " + nf.format(items % (double)stacksize);
        }
        return nf.format(items);
    }

    public static void sendMessage(FabricClientCommandSource source, String[] message, Boolean ... isHelpMessage) {
        class_5250 messageText = class_2561.method_43470((String)"");
        Object m = "";
        for (int i = 0; i < message.length; ++i) {
            if (i % 2 == 0) {
                messageText.method_10852((class_2561)class_2561.method_43470((String)message[i]));
                m = (String)m + message[i];
                continue;
            }
            messageText.method_10852((class_2561)class_2561.method_43470((String)("\u00a7a" + message[i] + "\u00a7f")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, message[i]))));
            m = (String)m + message[i];
        }
        if (isHelpMessage.length > 0 && isHelpMessage[0].booleanValue()) {
            source.getPlayer().method_43496((class_2561)messageText);
            return;
        }
        messageText.method_10852((class_2561)class_2561.method_43470((String)" "));
        source.getPlayer().method_43496((class_2561)messageText.method_10852((class_2561)class_2561.method_43470((String)"\u00a77[Click to Copy]\u00a7f").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, ((String)m).replaceAll("\u00a7a", "").replaceAll("\u00a7f", ""))))));
    }

    public static void sendMessage(FabricClientCommandSource source, CalcMessageBuilder messageBuilder) {
        source.sendFeedback(messageBuilder.generateStyledText());
    }

    public static void sendMessageServer(class_2168 source, String[] message, Boolean ... isHelpMessage) {
        class_5250 messageText = class_2561.method_43470((String)"");
        Object m = "";
        for (int i = 0; i < message.length; ++i) {
            if (i % 2 == 0) {
                messageText.method_10852((class_2561)class_2561.method_43470((String)message[i]));
                m = (String)m + message[i];
                continue;
            }
            messageText.method_10852((class_2561)class_2561.method_43470((String)("\u00a7a" + message[i] + "\u00a7f")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, message[i]))));
            m = (String)m + message[i];
        }
        if (isHelpMessage.length > 0 && isHelpMessage[0].booleanValue()) {
            source.method_44023().method_43496((class_2561)messageText);
            return;
        }
        messageText.method_10852((class_2561)class_2561.method_43470((String)" "));
        source.method_45068((class_2561)messageText.method_10852((class_2561)class_2561.method_43470((String)"\u00a77[Click to Copy]\u00a7f").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, ((String)m).replaceAll("\u00a7a", "").replaceAll("\u00a7f", ""))))));
    }

    public static void sendMessageServer(class_2168 source, final CalcMessageBuilder messageBuilder) {
        source.method_9226((Supplier)new Supplier<class_2561>(){

            @Override
            public class_2561 get() {
                return messageBuilder.generateStyledText();
            }
        }, Objects.isNull(source.method_44023()));
    }
}

