/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.util;

import com.google.common.collect.Sets;
import de.siphalor.mousewheelie.MWConfig;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ItemStackUtils {
    private static final class_2487 EMPTY_COMPOUND = new class_2487();

    public static boolean canCombine(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    public static int compareEqualItems(class_1799 a, class_1799 b) {
        int cmp = Integer.compare(b.method_7947(), a.method_7947());
        if (cmp != 0) {
            return cmp;
        }
        return ItemStackUtils.compareEqualItems2(a, b);
    }

    private static int compareEqualItems2(class_1799 a, class_1799 b) {
        if (a.method_7938()) {
            if (!b.method_7938()) {
                return -1;
            }
            return ItemStackUtils.compareEqualItems3(a, b);
        }
        if (b.method_7938()) {
            return 1;
        }
        return ItemStackUtils.compareEqualItems3(a, b);
    }

    private static int compareEqualItems3(class_1799 a, class_1799 b) {
        Iterator tooltipsA = a.method_7950(null, (class_1836)class_1836.class_1837.field_41070).iterator();
        Iterator tooltipsB = b.method_7950(null, (class_1836)class_1836.class_1837.field_41070).iterator();
        while (tooltipsA.hasNext()) {
            if (!tooltipsB.hasNext()) {
                return 1;
            }
            int cmp = ((class_2561)tooltipsA.next()).getString().compareToIgnoreCase(((class_2561)tooltipsB.next()).getString());
            if (cmp == 0) continue;
            return cmp;
        }
        if (tooltipsB.hasNext()) {
            return -1;
        }
        return ItemStackUtils.compareEqualItems4(a, b);
    }

    private static int compareEqualItems4(class_1799 a, class_1799 b) {
        class_1792 item = a.method_7909();
        if (item instanceof class_1768) {
            float[] hsbB;
            int colorA = ((class_1768)item).method_7800(a);
            int colorB = ((class_1768)item).method_7800(b);
            float[] hsbA = Color.RGBtoHSB(colorA >> 16 & 0xFF, colorA >> 8 & 0xFF, colorA & 0xFF, null);
            int cmp = Float.compare(hsbA[0], (hsbB = Color.RGBtoHSB(colorB >> 16 & 0xFF, colorB >> 8 & 0xFF, colorB & 0xFF, null))[0]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[1], hsbB[1]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[2], hsbB[2]);
            if (cmp != 0) {
                return cmp;
            }
        }
        return ItemStackUtils.compareEqualItems5(a, b);
    }

    private static int compareEqualItems5(class_1799 a, class_1799 b) {
        return Integer.compare(a.method_7919(), b.method_7919());
    }

    public static class_2487 getTagOrEmpty(class_1799 stack) {
        if (stack.method_7985()) {
            return stack.method_7969();
        }
        return EMPTY_COMPOUND;
    }

    public static boolean areTagsEqualExcept(class_1799 a, class_1799 b, String ... keys) {
        HashSet checkedKeys;
        class_2487 tagB;
        class_2487 tagA = ItemStackUtils.getTagOrEmpty(a);
        if (!ItemStackUtils.areTagsEqualExceptOneSided(tagA, tagB = ItemStackUtils.getTagOrEmpty(b), checkedKeys = Sets.newHashSet((Object[])keys))) {
            return false;
        }
        return ItemStackUtils.areTagsEqualExceptOneSided(tagB, tagA, checkedKeys);
    }

    private static boolean areTagsEqualExceptOneSided(class_2487 tagA, class_2487 tagB, Set<String> checkedKeys) {
        for (String key : tagA.method_10541()) {
            if (checkedKeys.contains(key)) continue;
            if (!tagB.method_10545(key)) {
                return false;
            }
            if (!tagA.method_10580(key).equals(tagB.method_10580(key))) {
                return false;
            }
            checkedKeys.add(key);
        }
        return true;
    }

    public static boolean areItemsOfSameKind(class_1799 stack1, class_1799 stack2) {
        return ItemStackUtils.areItemsOfSameKind(stack1, stack2, MWConfig.general.itemKindsNbtMatchMode);
    }

    public static boolean areItemsOfSameKind(class_1799 stack1, class_1799 stack2, NbtMatchMode mode) {
        switch (mode) {
            case NONE: {
                return stack1.method_7909() == stack2.method_7909();
            }
            case ALL: {
                return class_1799.method_7973((class_1799)stack1, (class_1799)stack2);
            }
            case SOME: {
                if (!class_1799.method_7984((class_1799)stack1, (class_1799)stack2)) {
                    return false;
                }
                return ItemStackUtils.areTagsEqualExcept(stack1, stack2, "Damage", "Enchantments");
            }
        }
        return false;
    }

    public static int hashByKind(class_1799 stack, NbtMatchMode mode) {
        switch (mode) {
            case NONE: {
                return stack.method_7909().hashCode();
            }
            case ALL: {
                return stack.hashCode();
            }
            case SOME: {
                HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append((Object)stack.method_7909());
                class_2487 nbt = stack.method_7969();
                if (nbt == null) {
                    return hashCodeBuilder.toHashCode();
                }
                nbt.method_10541().stream().sorted().forEachOrdered(key -> {
                    if (key.equals("Damage") || key.equals("Enchantments")) {
                        return;
                    }
                    hashCodeBuilder.append(key).append((Object)nbt.method_10580(key));
                });
                return hashCodeBuilder.toHashCode();
            }
        }
        return 0;
    }

    public static enum NbtMatchMode {
        NONE,
        SOME,
        ALL;

    }
}

