/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.utils;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.utils.WakeHandler;
import com.goby56.wakes.utils.WakeNode;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class WakesUtils {
    public static void placeSingleSplash(class_1937 world, class_1297 producer) {
        WakeHandler instance = WakeHandler.getInstance();
        if (instance == null) {
            return;
        }
        float height = WakesUtils.getWaterLevel(world, producer);
        instance.insert(new WakeNode(new class_243(producer.method_23317(), (double)height, producer.method_23321()), (int)((float)WakesClient.CONFIG_INSTANCE.splashStrength * producer.field_6017)));
    }

    public static void placeWakeTrail(class_1937 world, class_1297 producer) {
        WakeHandler wakeHandler = WakeHandler.getInstance();
        if (wakeHandler == null) {
            return;
        }
        float height = WakesUtils.getWaterLevel(world, producer);
        double velocity = ((ProducesWake)producer).getHorizontalVelocity();
        if (producer instanceof class_1690) {
            class_1690 boat = (class_1690)producer;
            for (WakeNode node : WakeNode.Factory.rowingNodes(boat, height)) {
                wakeHandler.insert(node);
            }
        }
        class_243 prevPos = ((ProducesWake)producer).getPrevPos();
        class_243 currPos = new class_243(producer.method_23317(), (double)height, producer.method_23321());
        ((ProducesWake)producer).setPrevPos(currPos);
        if (prevPos == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.thickNodeTrail(prevPos.field_1352, prevPos.field_1350, currPos.field_1352, currPos.field_1350, height, WakesClient.CONFIG_INSTANCE.initialStrength, velocity, producer.method_17681())) {
            wakeHandler.insert(node);
        }
    }

    public static void bresenhamLine(int x1, int y1, int x2, int y2, ArrayList<Long> points) {
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y2 < y1) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
            }
            for (int y = y1; y < y2 + 1; ++y) {
                points.add(WakesUtils.posAsLong(x1, y));
            }
        } else {
            float k = (float)dy / (float)dx;
            int adjust = k >= 0.0f ? 1 : -1;
            int offset = 0;
            if (k <= 1.0f && k >= -1.0f) {
                int delta = Math.abs(dy) * 2;
                int threshold = Math.abs(dx);
                int thresholdInc = Math.abs(dx) * 2;
                int y = y1;
                if (x2 < x1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    y = y2;
                }
                for (int x = x1; x < x2 + 1; ++x) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    y += adjust;
                    threshold += thresholdInc;
                }
            } else {
                int delta = Math.abs(dx) * 2;
                int threshold = Math.abs(dy);
                int thresholdInc = Math.abs(dy) * 2;
                int x = x1;
                if (y2 < y1) {
                    int temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                for (int y = y1; y < y2 + 1; ++y) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    x += adjust;
                    threshold += thresholdInc;
                }
            }
        }
    }

    public static long posAsLong(int x, int y) {
        int xs = x >> 31 & 1;
        int ys = y >> 31 & 1;
        long pos = (long)(x &= Integer.MAX_VALUE) << 32 | (long)(y &= Integer.MAX_VALUE);
        pos ^= ((long)(-xs) ^ pos) & Long.MIN_VALUE;
        pos ^= ((long)(-ys) ^ pos) & 0x80000000L;
        return pos;
    }

    public static int[] longAsPos(long pos) {
        return new int[]{(int)(pos >> 32), (int)pos};
    }

    public static class_5250 translatable(String category, String field) {
        return class_2561.method_43471((String)String.format("%s.%s.%s", category, "wakes", field));
    }

    public static int[] abgrInt2rgbaArr(int n) {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                arr[n2] = arr[n2] | (n >> i * 8 + j & 1) << 7 - j;
            }
        }
        return arr;
    }

    public static int rgbaArr2abgrInt(int[] arr) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                n |= (arr[i] >> j & 1) << i * 8 + j;
            }
        }
        return n;
    }

    public static float getWaterLevel(class_1937 world, class_1297 entityInWater) {
        class_238 box = entityInWater.method_5829();
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15384((double)box.field_1320);
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15384((double)box.field_1325);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15384((double)box.field_1324);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        block0: for (int y = minY; y < maxY; ++y) {
            float f = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    blockPos.method_10103(x, y, z);
                    class_3610 fluidState = world.method_8316((class_2338)blockPos);
                    if (fluidState.method_15767(class_3486.field_15517)) {
                        f = Math.max(f, fluidState.method_15763((class_1922)world, (class_2338)blockPos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockPos.method_10264() + f;
        }
        return maxY + 1;
    }
}

