/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.particle.custom;

import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.particle.WakeParticleType;
import com.goby56.wakes.render.model.WakeModel;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3879;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WakeParticle
extends class_703 {
    class_3879 wakeModel;
    class_1921 wakeLayer;
    class_1297 owner;
    float yaw;
    float prevYaw;
    LinkedList<Node> wakeNodes;

    protected WakeParticle(class_638 world, double x, double y, double z) {
        super(world, x, y, z);
        this.method_3077(60);
        this.method_3080(3.0f, 0.0f);
        this.wakeNodes = new LinkedList();
        this.wakeModel = new WakeModel(class_310.method_1551().method_31974().method_32072(WakeModel.MODEL_LAYER));
        class_2960 wakeTexture = new class_2960("wakes", "textures/entity/wake_texture.png");
        this.wakeLayer = class_1921.method_23580((class_2960)wakeTexture);
    }

    public void method_3070() {
        class_1297 class_12972;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.prevYaw = this.yaw;
        if (this.owner != null && (class_12972 = this.owner) instanceof ProducesWake) {
            class_1657 player;
            class_1297 class_12973;
            ProducesWake wakeOwner = (ProducesWake)class_12972;
            if (!wakeOwner.shouldSpawnWake() || (class_12973 = this.owner) instanceof class_1657 && (player = (class_1657)class_12973).method_7325()) {
                this.owner = null;
            } else {
                class_243 vel = this.owner.method_18798();
                this.yaw = 90.0f - (float)(57.29577951308232 * Math.atan2(vel.field_1350, vel.field_1352));
                class_243 ownerPos = this.owner.method_19538().method_1019(vel.method_1024((float)Math.PI).method_1029().method_1021(1.5));
                this.method_3063(ownerPos.field_1352, this.getWaterLevel(), ownerPos.field_1350);
                this.wakeNodes.add(new Node(vel, new class_243(this.field_3874, this.field_3854, this.field_3871), this.yaw));
            }
        }
        if (this.wakeNodes.size() == 0) {
            this.method_3085();
            return;
        }
        for (Node node : this.wakeNodes) {
            node.tick();
        }
        if (this.wakeNodes.getFirst().age > this.field_3847) {
            this.wakeNodes.removeFirst();
        }
    }

    private float getWaterLevel() {
        class_238 box = this.owner.method_5829();
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15384((double)box.field_1320);
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15384((double)box.field_1325);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15384((double)box.field_1324);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        block0: for (int y = minY; y < maxY; ++y) {
            float f = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    blockPos.method_10103(x, y, z);
                    class_3610 fluidState = this.field_3851.method_8316((class_2338)blockPos);
                    if (fluidState.method_15767(class_3486.field_15517)) {
                        f = Math.max(f, fluidState.method_15763((class_1922)this.field_3851, (class_2338)blockPos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockPos.method_10264() + f;
        }
        return maxY + 1;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        class_4587 modelMatrix = this.getMatrixStackFromCamera(camera, tickDelta);
        int light = this.method_3068(tickDelta);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 modelConsumer = immediate.getBuffer(this.wakeLayer);
        float yawLerp = class_3532.method_16439((float)tickDelta, (float)this.prevYaw, (float)this.yaw);
        modelMatrix.method_22907(class_7833.field_40716.rotationDegrees(yawLerp + 180.0f));
        this.wakeModel.method_2828(modelMatrix, modelConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        immediate.method_22993();
    }

    private class_4587 getMatrixStackFromCamera(class_4184 camera, float tickDelta) {
        class_243 cameraPos = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        class_4587 matrixStack = new class_4587();
        matrixStack.method_46416(x, y, z);
        return matrixStack;
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    @Environment(value=EnvType.CLIENT)
    public class Node {
        public final class_243 ownerVelocity;
        public final class_243 position;
        public final float yaw;
        public final int maxAge;
        public int age;

        public Node(class_243 ownerVelocity, class_243 position, float yaw) {
            this.ownerVelocity = ownerVelocity;
            this.position = position;
            this.yaw = yaw;
            this.maxAge = WakeParticle.this.field_3847;
            this.age = 0;
        }

        public void tick() {
            ++this.age;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 spriteSet) {
            this.sprites = spriteSet;
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velX, double velY, double velZ) {
            WakeParticle wake = new WakeParticle(world, x, y, z);
            if (parameters instanceof WakeParticleType) {
                WakeParticleType type = (WakeParticleType)parameters;
                wake.owner = type.owner;
                wake.yaw = wake.prevYaw = type.owner.method_36454();
            }
            return wake;
        }
    }
}

