/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.render.BlendingFunction;
import com.goby56.wakes.utils.WakeColor;
import com.goby56.wakes.utils.WakeHandler;
import com.goby56.wakes.utils.WakeNode;
import com.goby56.wakes.utils.WakesUtils;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class YACLIntegration {
    public static class_437 createScreen(class_437 parent) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        Option wakeOpacityOption = YACLIntegration.optionOf(Integer.class, "wake_opacity").binding((Object)100, () -> (int)(config.wakeOpacity * 100.0f), val -> {
            config.wakeOpacity = (float)val.intValue() / 100.0f;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 100)).available(config.blendMode.canVaryOpacity).build();
        return YetAnotherConfigLib.createBuilder().title((class_2561)WakesUtils.translatable("config", "title")).category(YACLIntegration.configCategory("wake_appearance").option(YACLIntegration.optionOf(WakesConfig.Resolution.class, "wake_resolution").binding((Object)WakesConfig.Resolution.SIXTEEN, () -> config.wakeResolution, WakeHandler::scheduleResolutionChange).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(WakesConfig.Resolution.class).valueFormatter(val -> WakesUtils.translatable("resolution", val.toString()))).build()).option(wakeOpacityOption).option(YACLIntegration.optionOf(BlendingFunction.class, "blend_mode").binding((Object)BlendingFunction.DEFAULT, () -> config.blendMode, val -> {
            config.blendMode = val;
            wakeOpacityOption.setAvailable(val.canVaryOpacity);
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(BlendingFunction.class).valueFormatter(val -> WakesUtils.translatable("blending_function", val.name().toLowerCase()))).build()).option(YACLIntegration.booleanOption("use_water_blending").binding((Object)true, () -> config.useWaterBlending, val -> {
            config.useWaterBlending = val;
        }).build()).build()).category(YACLIntegration.configCategory("wake_behaviour").group(YACLIntegration.group("wake_spawning").option(YACLIntegration.wakeSpawningRulesOption("boat_wake_rules")).option(YACLIntegration.wakeSpawningRulesOption("player_wake_rules")).option(YACLIntegration.wakeSpawningRulesOption("other_players_wake_rules")).option(YACLIntegration.wakeSpawningRulesOption("mobs_wake_rules")).option(YACLIntegration.wakeSpawningRulesOption("items_wake_rules")).option(YACLIntegration.booleanOption("wakes_in_running_water").binding((Object)false, () -> config.wakesInRunningWater, val -> {
            config.wakesInRunningWater = val;
        }).build()).build()).option(YACLIntegration.optionOf(Float.class, "wave_speed").binding((Object)Float.valueOf(0.95f), () -> Float.valueOf(config.waveSpeed), val -> {
            config.waveSpeed = val.floatValue();
            WakeNode.calculateAlpha();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 2.0f, 0.01f)).build()).option(YACLIntegration.optionOf(Integer.class, "initial_wave_strength").binding((Object)20, () -> config.initialStrength, val -> {
            config.initialStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).option(YACLIntegration.optionOf(Integer.class, "paddle_strength").binding((Object)100, () -> config.paddleStrength, val -> {
            config.paddleStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).option(YACLIntegration.optionOf(Integer.class, "splash_strength").binding((Object)100, () -> config.splashStrength, val -> {
            config.splashStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).option(YACLIntegration.optionOf(Double.class, "minimum_producer_velocity").binding((Object)0.1, () -> config.minimumProducerVelocity, val -> {
            config.minimumProducerVelocity = val;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(YACLIntegration.optionOf(Float.class, "wave_decay").binding((Object)Float.valueOf(0.9f), () -> Float.valueOf(config.waveDecay), val -> {
            config.waveDecay = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 1.0f, 0.01f)).build()).build()).category(YACLIntegration.configCategory("debug").option(YACLIntegration.optionOf(Integer.class, "flood_fill_distance").binding((Object)3, () -> config.floodFillDistance, val -> {
            config.floodFillDistance = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 1, 5)).build()).option(YACLIntegration.optionOf(Integer.class, "ticks_before_fill").binding((Object)2, () -> config.ticksBeforeFill, val -> {
            config.ticksBeforeFill = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 1, 5)).build()).option(YACLIntegration.booleanOption("use_9_point_stencil").binding((Object)true, () -> config.use9PointStencil, val -> {
            config.use9PointStencil = val;
        }).build()).option(YACLIntegration.booleanOption("draw_debug_boxes").binding((Object)false, () -> config.drawDebugBoxes, val -> {
            config.drawDebugBoxes = val;
        }).build()).option(YACLIntegration.booleanOption("render_wakes").binding((Object)true, () -> config.renderWakes, val -> {
            config.renderWakes = val;
        }).build()).option(YACLIntegration.booleanOption("spawn_wakes").binding((Object)true, () -> config.spawnWakes, val -> {
            config.spawnWakes = val;
        }).build()).group(YACLIntegration.intervalGroup(0, WakeColor.TRANSPARENT, -50, -45)).group(YACLIntegration.intervalGroup(1, WakeColor.DARK_GRAY, -45, -35)).group(YACLIntegration.intervalGroup(2, WakeColor.GRAY, -35, -30)).group(YACLIntegration.intervalGroup(3, WakeColor.LIGHT_GRAY, -30, -15)).group(YACLIntegration.intervalGroup(4, WakeColor.TRANSPARENT, -15, 2)).group(YACLIntegration.intervalGroup(5, WakeColor.LIGHT_GRAY, 2, 10)).group(YACLIntegration.intervalGroup(6, WakeColor.WHITE, 10, 20)).group(YACLIntegration.intervalGroup(7, WakeColor.LIGHT_GRAY, 20, 40)).group(YACLIntegration.intervalGroup(8, WakeColor.GRAY, 40, 50)).build()).save(config::saveConfig).build().generateScreen(parent);
    }

    private static ConfigCategory.Builder configCategory(String name) {
        return ConfigCategory.createBuilder().name((class_2561)WakesUtils.translatable("config_category", name));
    }

    private static OptionGroup.Builder group(String name) {
        return OptionGroup.createBuilder().name((class_2561)WakesUtils.translatable("option_group", name));
    }

    private static <T> Option.Builder<T> optionOf(Class<T> optionType, String name) {
        return Option.createBuilder().name((class_2561)WakesUtils.translatable("option", name));
    }

    private static IntegerSliderControllerBuilder integerSlider(Option<Integer> option, int min, int max) {
        return (IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(option).range((Number)min, (Number)max)).step((Number)1);
    }

    private static FloatSliderControllerBuilder floatSlider(Option<Float> option, float min, float max, float step) {
        return (FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create(option).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step));
    }

    private static Option.Builder<Boolean> booleanOption(String name) {
        return Option.createBuilder().name((class_2561)WakesUtils.translatable("option", name)).controller(TickBoxControllerBuilder::create);
    }

    private static Option<WakesConfig.WakeSpawningRule> wakeSpawningRulesOption(String name) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        return Option.createBuilder().name((class_2561)WakesUtils.translatable("option", name)).binding((Object)WakesConfig.WakeSpawningRule.WAKES_AND_SPLASHES, () -> config.wakeSpawningRules.get(name), val -> config.wakeSpawningRules.put(name, (WakesConfig.WakeSpawningRule)((Object)val))).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(WakesConfig.WakeSpawningRule.class).valueFormatter(val -> WakesUtils.translatable("wake_spawn_rule", val.name().toLowerCase()))).build();
    }

    private static OptionGroup intervalGroup(int n, WakeColor defaultColor, int defaultLower, int defaultUpper) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        return OptionGroup.createBuilder().name((class_2561)WakesUtils.translatable("option_group", "interval" + (n + 1))).option(YACLIntegration.optionOf(Integer.class, "lower").binding((Object)defaultLower, () -> config.colorIntervals.get((int)n).lower, config.colorIntervals.get(n)::setLower).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, -50, 50)).build()).option(YACLIntegration.optionOf(Integer.class, "upper").binding((Object)defaultUpper, () -> config.colorIntervals.get((int)n).upper, config.colorIntervals.get(n)::setUpper).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, -50, 50)).build()).option(YACLIntegration.optionOf(WakeColor.class, "color").binding((Object)defaultColor, () -> config.colorIntervals.get((int)n).color, config.colorIntervals.get(n)::setColor).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(WakeColor.class).valueFormatter(val -> WakesUtils.translatable("config", "color." + val.name().toLowerCase()))).build()).build();
    }
}

