/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.string.number;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.controllers.slider.FloatSliderController;
import dev.isxander.yacl3.gui.controllers.string.number.NumberFieldController;
import java.util.function.Function;
import net.minecraft.class_2561;

public class FloatFieldController
extends NumberFieldController<Float> {
    private final float min;
    private final float max;

    public FloatFieldController(Option<Float> option, float min, float max, Function<Float, class_2561> formatter) {
        super(option, formatter);
        this.min = min;
        this.max = max;
    }

    public FloatFieldController(Option<Float> option, float min, float max) {
        this(option, min, max, FloatSliderController.DEFAULT_FORMATTER);
    }

    public FloatFieldController(Option<Float> option, Function<Float, class_2561> formatter) {
        this(option, -3.4028235E38f, Float.MAX_VALUE, formatter);
    }

    public FloatFieldController(Option<Float> option) {
        this(option, -3.4028235E38f, Float.MAX_VALUE, FloatSliderController.DEFAULT_FORMATTER);
    }

    public static FloatFieldController createInternal(Option<Float> option, float min, float max, ValueFormatter<Float> formatter) {
        return new FloatFieldController(option, min, max, formatter::format);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public String getString() {
        return String.valueOf(this.option().pendingValue());
    }

    @Override
    public void setPendingValue(double value) {
        this.option().requestSet(Float.valueOf((float)value));
    }

    @Override
    public double pendingValue() {
        return ((Float)this.option().pendingValue()).floatValue();
    }
}

