/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.EMFModelPartWithState;

@Environment(value=EnvType.CLIENT)
public class EMFModelPartVanilla
extends EMFModelPartWithState {
    final String name;
    final boolean isOptiFinePartSpecified;
    final boolean rootType;
    final Set<Integer> hideInTheseStates = new HashSet<Integer>();

    public EMFModelPartVanilla(String name, class_630 vanillaPart, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> allVanillaParts) {
        super(new ArrayList<class_630.class_628>(), new HashMap<String, class_630>());
        this.name = name;
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > EMF vanilla part made: " + name);
        }
        this.isOptiFinePartSpecified = optifinePartNames.contains(name);
        this.rootType = name.equals("root") || name.equals("EMF_root");
        EMFModelPartWithState.EMFModelState state = this.getStateOf(vanillaPart);
        this.setFromState(state);
        Map<String, class_630> children = this.getChildrenEMF();
        for (Map.Entry<String, class_630> child : ((ModelPartAccessor)vanillaPart).getChildren().entrySet()) {
            EMFModelPartVanilla vanilla = new EMFModelPartVanilla(child.getKey(), child.getValue(), optifinePartNames, allVanillaParts);
            children.put(child.getKey(), vanilla);
            allVanillaParts.put(child.getKey(), vanilla);
        }
        this.vanillaChildren = this.getChildrenEMF();
        this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
    }

    @Override
    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.hideInTheseStates.contains(this.currentModelVariantState)) {
            super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    class_630 getVanillaModelPartsOfCurrentState() {
        HashMap<String, class_630> children = new HashMap<String, class_630>();
        for (Map.Entry<String, class_630> child : this.getChildrenEMF().entrySet()) {
            class_630 class_6302 = child.getValue();
            if (!(class_6302 instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)class_6302;
            children.put(child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        class_630 part = new class_630(((ModelPartAccessor)((Object)this)).getCuboids(), children);
        part.method_41918(this.method_41921());
        part.field_3654 = this.field_3654;
        part.field_3674 = this.field_3674;
        part.field_3675 = this.field_3675;
        part.field_3655 = this.field_3655;
        part.field_3656 = this.field_3656;
        part.field_3657 = this.field_3657;
        part.field_37938 = this.field_37938;
        part.field_37939 = this.field_37939;
        part.field_37940 = this.field_37940;
        return part;
    }

    public void setHideInTheseStates(int variant) {
        this.hideInTheseStates.add(variant);
        this.getChildrenEMF().values().forEach(part -> {
            if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                if (!vanilla.isOptiFinePartSpecified) {
                    vanilla.setHideInTheseStates(variant);
                }
            }
        });
    }

    public void receiveRootAnimationRunnable(int variant, Runnable run) {
        ((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(variant)).animation().setAnimation(run);
    }

    @Override
    public String toString() {
        return "[vanilla part " + this.name + "]";
    }
}

