/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.xiaocihua.stacktonearbychests.StackToNearbyChests;
import io.github.xiaocihua.stacktonearbychests.gui.BlockContainerEntry;
import io.github.xiaocihua.stacktonearbychests.gui.EntityContainerEntry;
import io.github.xiaocihua.stacktonearbychests.gui.FlatColorButton;
import io.github.xiaocihua.stacktonearbychests.gui.ItemEntry;
import io.github.xiaocihua.stacktonearbychests.gui.SelectableEntryList;
import io.github.xiaocihua.stacktonearbychests.gui.WBoxCustom;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public abstract class EntryPicker
extends WBox {
    protected static final String PREFIX = "stack-to-nearby-chests.options.entryPicker.";
    private final WLabel title;
    private final WTextField searchByName;
    private final WTextField searchByID;
    protected SelectableEntryList<class_2960> entryList;
    private final WBoxCustom bottomBar;
    private Optional<Runnable> onClose = Optional.empty();

    public EntryPicker(Consumer<List<class_2960>> consumer) {
        super(Axis.VERTICAL);
        this.insets = Insets.ROOT_PANEL;
        this.setSize(250, 0);
        this.title = new WLabel(this.getTitle(), 0xF5F5F5);
        this.add((WWidget)this.title);
        this.searchByName = new WTextField((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.searchByName")).setChangedListener(searchStr -> this.entryList.setData(this.searchByName((String)searchStr)));
        this.add((WWidget)this.searchByName);
        this.searchByID = new WTextField((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.searchByID")).setChangedListener(searchStr -> this.entryList.setData(this.searchByID((String)searchStr)));
        this.add((WWidget)this.searchByID);
        this.entryList = this.getEntryList();
        this.add((WWidget)this.entryList);
        this.bottomBar = new WBoxCustom(Axis.HORIZONTAL);
        this.bottomBar.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        WButton addButton = new FlatColorButton((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.add")).setBorder().setOnClick(() -> {
            consumer.accept(this.entryList.getSelectedData());
            this.close();
        });
        this.bottomBar.add((WWidget)addButton, 50);
        WButton cancelButton = new FlatColorButton((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.cancel")).setBorder().setOnClick(this::close);
        this.bottomBar.add((WWidget)cancelButton, 50);
        this.add((WWidget)this.bottomBar);
        this.layout();
    }

    public void layout() {
        int width = this.width - this.insets.left() - this.insets.right();
        this.title.setSize(width, 12);
        this.searchByName.setSize(width, 20);
        this.searchByID.setSize(width, 20);
        this.entryList.setSize(width, 140);
        this.bottomBar.setSize(width, 20);
        super.layout();
    }

    public abstract class_2561 getTitle();

    public abstract List<class_2960> searchByName(String var1);

    public abstract List<class_2960> searchByID(String var1);

    public abstract SelectableEntryList<class_2960> getEntryList();

    public void setOnClose(Runnable onClose) {
        this.onClose = Optional.ofNullable(onClose);
    }

    public void close() {
        this.onClose.ifPresent(Runnable::run);
    }

    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        this.getBackgroundPainter().paintBackground(context, x, y, (WWidget)this);
        super.paint(context, x, y, mouseX, mouseY);
    }

    public BackgroundPainter getBackgroundPainter() {
        return BackgroundPainter.createNinePatch((class_2960)new class_2960("stack-to-nearby-chests", "textures/background_dark_bordered.png"));
    }

    public boolean canResize() {
        return false;
    }

    public static class EntityContainerPicker
    extends EntryPicker {
        public EntityContainerPicker(Consumer<List<class_2960>> consumer) {
            super(consumer);
            this.entryList.setData(this.searchByName(""));
        }

        @Override
        public class_2561 getTitle() {
            return class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.addContainersToList");
        }

        @Override
        public List<class_2960> searchByName(String searchStr) {
            return class_7923.field_41177.method_10220().filter(entityType -> StringUtils.containsIgnoreCase((CharSequence)entityType.method_5897().getString(), (CharSequence)searchStr)).map(arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0)).toList();
        }

        @Override
        public List<class_2960> searchByID(String searchStr) {
            return class_7923.field_41177.method_10235().stream().filter(identifier -> StringUtils.containsIgnoreCase((CharSequence)identifier.toString(), (CharSequence)searchStr)).toList();
        }

        @Override
        public SelectableEntryList<class_2960> getEntryList() {
            return new SelectableEntryList<class_2960>(EntityContainerEntry::new);
        }
    }

    public static class BlockContainerPicker
    extends EntryPicker {
        Predicate<class_2248> nonVanillaStyleContainer = block -> false;

        public BlockContainerPicker(Consumer<List<class_2960>> consumer) {
            super(consumer);
            if (StackToNearbyChests.IS_EXPANDED_STORAGE_MOD_LOADED) {
                try {
                    Class<?> clazz = Class.forName("compasses.expandedstorage.common.block.OpenableBlock");
                    this.nonVanillaStyleContainer = clazz::isInstance;
                }
                catch (ClassNotFoundException e) {
                    StackToNearbyChests.LOGGER.error("Unable to find class compasses.expandedstorage.common.block.OpenableBlock");
                }
            }
            this.entryList.setData(this.searchByName(""));
        }

        @Override
        public class_2561 getTitle() {
            return class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.addContainersToList");
        }

        @Override
        public List<class_2960> searchByName(String searchStr) {
            return class_7923.field_41175.method_10220().filter(this.nonVanillaStyleContainer.or(block -> block instanceof class_2237)).filter(block -> StringUtils.containsIgnoreCase((CharSequence)block.method_9518().toString(), (CharSequence)searchStr)).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).toList();
        }

        @Override
        public List<class_2960> searchByID(String searchStr) {
            return class_7923.field_41175.method_10220().filter(this.nonVanillaStyleContainer.or(block -> block instanceof class_2237)).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).filter(identifier -> StringUtils.containsIgnoreCase((CharSequence)identifier.toString(), (CharSequence)searchStr)).toList();
        }

        @Override
        public SelectableEntryList<class_2960> getEntryList() {
            return new SelectableEntryList<class_2960>(BlockContainerEntry::new);
        }
    }

    public static class ItemPicker
    extends EntryPicker {
        public ItemPicker(Consumer<List<class_2960>> consumer) {
            super(consumer);
            this.entryList.setData(this.searchByName(""));
        }

        @Override
        public class_2561 getTitle() {
            return class_2561.method_43471((String)"stack-to-nearby-chests.options.entryPicker.addItemsToList");
        }

        @Override
        public List<class_2960> searchByName(String searchStr) {
            return class_7923.field_41178.method_10220().filter(item -> StringUtils.containsIgnoreCase((CharSequence)item.method_7848().getString(), (CharSequence)searchStr)).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).toList();
        }

        @Override
        public List<class_2960> searchByID(String searchStr) {
            return class_7923.field_41178.method_10235().stream().filter(identifier -> StringUtils.containsIgnoreCase((CharSequence)identifier.toString(), (CharSequence)searchStr)).toList();
        }

        @Override
        public SelectableEntryList<class_2960> getEntryList() {
            return new SelectableEntryList<class_2960>(ItemEntry::new);
        }
    }
}

