/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import io.github.xiaocihua.stacktonearbychests.ForEachBlockContainerTask;
import io.github.xiaocihua.stacktonearbychests.ForEachEntityContainerTask;
import io.github.xiaocihua.stacktonearbychests.LockedSlots;
import io.github.xiaocihua.stacktonearbychests.ModOptions;
import io.github.xiaocihua.stacktonearbychests.StackToNearbyChests;
import io.github.xiaocihua.stacktonearbychests.event.ClickSlotCallback;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class InventoryActions {
    public static void init() {
        ClickSlotCallback.BEFORE.register((syncId, slotId, button, actionType, player) -> {
            if (slotId == -999 && actionType == class_1713.field_7790 && StackToNearbyChests.currentStackToNearbyContainersButton.map(class_339::method_49606).orElse(false).booleanValue()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public static void stackToNearbyContainers() {
        InventoryActions.forEachContainer(InventoryActions::quickStack, ModOptions.get().behavior.stackingTargets, ModOptions.get().behavior.stackingTargetEntities);
    }

    public static void stackToNearbyContainers(class_1792 item) {
        InventoryActions.forEachContainer(screenHandler -> InventoryActions.quickStack(screenHandler, item), ModOptions.get().behavior.stackingTargets, ModOptions.get().behavior.stackingTargetEntities);
    }

    public static void restockFromNearbyContainers() {
        InventoryActions.forEachContainer(InventoryActions::restock, ModOptions.get().behavior.restockingSources, ModOptions.get().behavior.restockingSourceEntities);
    }

    public static boolean canMerge(class_1799 stack, class_1799 otherStack) {
        return stack.method_7947() < stack.method_7914() && class_1799.method_31577((class_1799)stack, (class_1799)otherStack);
    }

    public static void forEachContainer(Consumer<class_1703> action, Collection<String> blockFilter, Collection<String> entityFilter) {
        class_310 client = class_310.method_1551();
        class_1297 cameraEntity = client.method_1560();
        class_638 world = client.field_1687;
        class_636 interactionManager = client.field_1761;
        class_746 player = client.field_1724;
        if (cameraEntity == null || world == null || interactionManager == null || player == null) {
            StackToNearbyChests.LOGGER.info("cameraEntity: {}, word: {}, interactionManager: {}, player: {}", new Object[]{cameraEntity, world, interactionManager, player});
            return;
        }
        if (player.method_7325()) {
            StackToNearbyChests.LOGGER.info("The player is in spectator mode");
            return;
        }
        if (player.method_5715()) {
            StackToNearbyChests.LOGGER.info("The player is sneaking");
            return;
        }
        ForEachBlockContainerTask task = new ForEachBlockContainerTask(client, cameraEntity, (class_1937)world, player, interactionManager, action, blockFilter);
        if (ModOptions.get().behavior.supportForContainerEntities.booleanValue() && !player.method_5765()) {
            task.thenStart(new ForEachEntityContainerTask(client, player, action, cameraEntity, (class_1937)world, interactionManager, entityFilter));
        }
        task.start();
    }

    public static void quickStack(class_1703 screenHandler) {
        SlotsInScreenHandler slots = SlotsInScreenHandler.of(screenHandler);
        Set<class_1792> itemsInContainer = slots.containerSlots().stream().map(slot -> slot.method_7677().method_7909()).filter(item -> !ModOptions.get().behavior.itemsThatWillNotBeStacked.contains(class_7923.field_41178.method_10221(item).toString())).collect(Collectors.toSet());
        InventoryActions.moveAll(screenHandler, slots.playerSlots, itemsInContainer);
    }

    public static void quickStack(class_1703 screenHandler, class_1792 item) {
        SlotsInScreenHandler slots = SlotsInScreenHandler.of(screenHandler);
        boolean hasSameTypeItems = slots.containerSlots.stream().anyMatch(slot -> slot.method_7677().method_31574(item));
        if (hasSameTypeItems) {
            InventoryActions.moveAll(screenHandler, slots.playerSlots(), Set.of(item));
        }
    }

    private static void moveAll(class_1703 screenHandler, List<class_1735> playerSlots, Set<class_1792> itemsToBeMoved) {
        playerSlots.stream().filter(slot -> !ModOptions.get().behavior.doNotQuickStackItemsFromTheHotbar.booleanValue() || !class_1661.method_7380((int)slot.method_34266())).filter(Predicate.not(InventoryActions::isSlotLocked)).filter(slot -> itemsToBeMoved.contains(slot.method_7677().method_7909())).filter(slot -> slot.method_7674((class_1657)class_310.method_1551().field_1724)).filter(class_1735::method_7681).forEach(slot -> InventoryActions.quickMove(screenHandler, slot));
    }

    public static void restock(class_1703 screenHandler) {
        SlotsInScreenHandler slots = SlotsInScreenHandler.of(screenHandler);
        slots.playerSlots().stream().filter(class_1735::method_7681).filter(slot -> slot.method_7677().method_7946()).filter(slot -> !ModOptions.get().behavior.itemsThatWillNotBeRestocked.contains(class_7923.field_41178.method_10221((Object)slot.method_7677().method_7909()).toString())).forEach(slot -> slots.containerSlots().stream().filter(containerSlot -> class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)containerSlot.method_7677())).peek(containerSlot -> {
            InventoryActions.pickup(screenHandler, containerSlot);
            InventoryActions.pickup(screenHandler, slot);
        }).filter(containerSlot -> !screenHandler.method_34255().method_7960()).findFirst().ifPresent(containerSlot -> InventoryActions.pickup(screenHandler, containerSlot)));
    }

    public static void quickMove(class_1703 screenHandler, class_1735 slot) {
        class_310 client = class_310.method_1551();
        client.field_1761.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7794, (class_1657)client.field_1724);
    }

    public static void pickup(class_1703 screenHandler, class_1735 slot) {
        class_310 client = class_310.method_1551();
        client.field_1761.method_2906(screenHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)client.field_1724);
    }

    private static boolean isSlotLocked(class_1735 slot) {
        if (StackToNearbyChests.IS_IPN_MOD_LOADED) {
            try {
                Class<?> clazz = Class.forName("org.anti_ad.mc.ipnext.event.LockSlotsHandler");
                Object instance = clazz.getField("INSTANCE").get(null);
                Boolean slotLocked = (Boolean)clazz.getMethod("isMappedSlotLocked", class_1735.class).invoke(instance, slot);
                if (slotLocked.booleanValue()) {
                    return true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                StackToNearbyChests.LOGGER.warn("An exception occurred when determining whether the slot is locked by IPN mod", (Throwable)e);
            }
        }
        return LockedSlots.isLocked(slot);
    }

    private record SlotsInScreenHandler(List<class_1735> playerSlots, List<class_1735> containerSlots) {
        static SlotsInScreenHandler of(class_1703 screenHandler) {
            Map<Boolean, List<class_1735>> inventories = screenHandler.field_7761.stream().collect(Collectors.partitioningBy(slot -> slot.field_7871 instanceof class_1661));
            return new SlotsInScreenHandler(inventories.get(true), inventories.get(false));
        }
    }
}

