/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import io.github.xiaocihua.stacktonearbychests.ForEachContainerTask;
import io.github.xiaocihua.stacktonearbychests.MathUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1606;
import net.minecraft.class_1703;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class ForEachBlockContainerTask
extends ForEachContainerTask {
    private final class_1937 world;
    private final class_636 interactionManager;
    private final float squaredReachDistance;
    private final class_1297 cameraEntity;
    private final Collection<String> filter;
    private final Iterator<class_2338> blocks;
    private final Set<class_2338> searchedBlocks = new HashSet<class_2338>();
    private boolean hasSearchedEnderChest = false;

    public ForEachBlockContainerTask(class_310 client, class_1297 cameraEntity, class_1937 world, class_746 player, class_636 interactionManager, Consumer<class_1703> action, Collection<String> filter) {
        super(client, player, action);
        this.world = world;
        this.interactionManager = interactionManager;
        float reachDistance = interactionManager.method_2904();
        this.squaredReachDistance = class_3532.method_27285((float)reachDistance);
        this.cameraEntity = cameraEntity;
        this.blocks = MathUtil.getBlocksInBox(MathUtil.getBox(cameraEntity.method_5836(0.0f), reachDistance)).iterator();
        this.filter = filter;
    }

    @Override
    protected boolean findAndOpenNextContainer() {
        while (this.blocks.hasNext()) {
            class_2680 state;
            class_2338 pos = this.blocks.next().method_10062();
            if (this.searchedBlocks.contains(pos) || !this.isOpenable(this.world, pos) || !this.filter.contains(class_7923.field_41175.method_10221((Object)(state = this.world.method_8320(pos)).method_26204()).toString())) continue;
            class_243 origin = this.cameraEntity.method_5836(0.0f);
            class_243 closestPos = MathUtil.getClosestPoint(pos, state.method_26218((class_1922)this.world, pos), origin);
            if (closestPos.method_1025(origin) > (double)this.squaredReachDistance) continue;
            this.searchedBlocks.add(pos);
            if (state.method_26204() == class_2246.field_10443) {
                if (this.hasSearchedEnderChest) continue;
                this.hasSearchedEnderChest = true;
            } else if (state.method_26204() == class_2246.field_10603) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2480.field_11496);
                class_2338 facingBlockPos = pos.method_10093(facing);
                for (class_2350 dir : class_2350.values()) {
                    class_2338 adjacentBlockPos;
                    class_2680 adjacentBlockState;
                    if (dir == facing || dir == facing.method_10153() || (adjacentBlockState = this.world.method_8320(adjacentBlockPos = facingBlockPos.method_10093(dir))).method_26204() != class_2246.field_10603 || adjacentBlockState.method_11654((class_2769)class_2480.field_11496) != dir.method_10153()) continue;
                    this.searchedBlocks.add(adjacentBlockPos);
                }
            } else {
                this.getTheOtherHalfOfLargeChest(this.world, pos).ifPresent(this.searchedBlocks::add);
            }
            class_3965 hitResult = new class_3965(closestPos, MathUtil.getFacingDirection(closestPos.method_1020(origin)).method_10153(), pos, false);
            this.interactionManager.method_2896(this.player, class_1268.field_5808, hitResult);
            return true;
        }
        return false;
    }

    private boolean isOpenable(class_1937 world, class_2338 pos) {
        class_2627 shulkerBoxBlockEntity;
        class_2680 state = world.method_8320(pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_1263) && state.method_26204() != class_2246.field_10443) {
            return false;
        }
        if (blockEntity instanceof class_2627 && this.isShulkerBoxBlocked(state, world, pos, shulkerBoxBlockEntity = (class_2627)blockEntity)) {
            return false;
        }
        if (state.method_26204() instanceof class_2281 || state.method_26204() == class_2246.field_10443) {
            if (class_2281.method_9756((class_1936)world, (class_2338)pos)) {
                return false;
            }
            return this.getTheOtherHalfOfLargeChest(world, pos).map(offsetPos -> !class_2281.method_9756((class_1936)world, (class_2338)offsetPos)).orElse(true);
        }
        return true;
    }

    private boolean isShulkerBoxBlocked(class_2680 state, class_1937 world, class_2338 pos, class_2627 shulkerBoxBlockEntity) {
        if (shulkerBoxBlockEntity.method_11313() != class_2627.class_2628.field_12065) {
            return false;
        }
        class_238 box = class_1606.method_33347((class_2350)((class_2350)state.method_11654((class_2769)class_2480.field_11496)), (float)0.0f, (float)0.5f).method_996(pos).method_1011(1.0E-6);
        return !world.method_18026(box);
    }

    private Optional<class_2338> getTheOtherHalfOfLargeChest(class_1937 world, class_2338 pos) {
        class_2338 offsetPos;
        class_2680 theOtherHalf;
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2281 && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && (theOtherHalf = world.method_8320(offsetPos = pos.method_10093(class_2281.method_9758((class_2680)state)))).method_26204() == state.method_26204() && state.method_11654((class_2769)class_2281.field_10768) == theOtherHalf.method_11654((class_2769)class_2281.field_10768) && class_2281.method_9758((class_2680)state) == class_2281.method_9758((class_2680)theOtherHalf).method_10153()) {
            return Optional.ofNullable(offsetPos);
        }
        return Optional.empty();
    }
}

