/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1309;

record WeightedAcoustic(List<Acoustic> theAcoustics, float[] probabilityThresholds) implements Acoustic
{
    public WeightedAcoustic(List<Acoustic> theAcoustics, float[] probabilityThresholds) {
        this.theAcoustics = theAcoustics = new ObjectImmutableList(theAcoustics);
        this.probabilityThresholds = probabilityThresholds;
    }

    public static WeightedAcoustic of(List<Acoustic> acoustics, List<Integer> weights) {
        int i;
        ObjectArrayList theAcoustics = new ObjectArrayList(acoustics);
        float[] probabilityThresholds = new float[acoustics.size() - 1];
        float total = 0.0f;
        for (i = 0; i < weights.size(); ++i) {
            if (weights.get(i) < 0) {
                throw new IllegalArgumentException("A probability weight can't be negative");
            }
            total += (float)weights.get(i).intValue();
        }
        for (i = 0; i < weights.size() - 1; ++i) {
            probabilityThresholds[i] = (float)weights.get(i).intValue() / total;
        }
        return new WeightedAcoustic((List<Acoustic>)theAcoustics, probabilityThresholds);
    }

    public static Acoustic fromJson(JsonObject json, AcousticsJsonParser context) {
        ObjectArrayList weights = new ObjectArrayList();
        ObjectArrayList acoustics = new ObjectArrayList();
        JsonArray sim = json.getAsJsonArray("array");
        Iterator iter = sim.iterator();
        while (iter.hasNext()) {
            JsonElement subElement = (JsonElement)iter.next();
            weights.add(subElement.getAsInt());
            if (!iter.hasNext()) {
                throw new JsonParseException("Probability has odd number of children!");
            }
            subElement = (JsonElement)iter.next();
            acoustics.add(context.solveAcoustic(subElement));
        }
        return WeightedAcoustic.of((List<Acoustic>)acoustics, (List<Integer>)weights);
    }

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        int marker;
        float rand = player.getRNG().nextFloat();
        for (marker = 0; marker < this.probabilityThresholds.length && this.probabilityThresholds[marker] < rand; ++marker) {
        }
        this.theAcoustics.get(marker).playSound(player, location, event, inputOptions);
    }
}

