/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.GuiHelper;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.minimap.waypoints.render.WaypointGuiRenderContext;
import xaero.common.minimap.waypoints.render.WaypointReader;
import xaero.common.minimap.waypoints.render.WaypointRenderProvider;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public final class WaypointsGuiRenderer
extends MinimapElementRenderer<Waypoint, WaypointGuiRenderContext> {
    private final AXaeroMinimap modMain;
    private final WaypointDeleter waypointReachDeleter;

    private WaypointsGuiRenderer(AXaeroMinimap modMain, WaypointReader elementReader, WaypointRenderProvider provider, WaypointGuiRenderContext context, WaypointDeleter waypointReachDeleter) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.waypointReachDeleter = waypointReachDeleter;
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, class_332 guiGraphics, class_4597.class_4598 renderTypeBuffers, class_327 font, class_276 framebuffer, MinimapRendererHelper helper, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Waypoint w, double partialX, double partialY, boolean cave, float partialTicks) {
        class_4587 matrixStack = guiGraphics.method_51448();
        if ((((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints || w.getWaypointType() != 1 && w.getWaypointType() != 2) && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L) {
            double correctOffZ;
            double correctDistance;
            double correctOffX = renderX - (double)w.getX(((WaypointGuiRenderContext)this.context).dimDiv);
            double correctOffY = renderY - (double)w.getY();
            if (!w.isYIncluded()) {
                correctOffY = 0.0;
            }
            if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = renderZ - (double)w.getZ(((WaypointGuiRenderContext)this.context).dimDiv)) * correctOffZ)) < 4.0) {
                this.waypointReachDeleter.add(w);
            }
        }
        matrixStack.method_22904(-1.0, -1.0, optionalDepth);
        if (((WaypointGuiRenderContext)this.context).scale <= 0 || location != 1) {
            matrixStack.method_22905(optionalScale, optionalScale, 1.0f);
        } else {
            matrixStack.method_22905((float)((WaypointGuiRenderContext)this.context).scale, (float)((WaypointGuiRenderContext)this.context).scale, 1.0f);
        }
        this.drawIconOnGUI(guiGraphics, helper, w, ((WaypointGuiRenderContext)this.context).settings, 0, 0, renderTypeBuffers, ((WaypointGuiRenderContext)this.context).waypointBackgroundConsumer);
        return true;
    }

    @Override
    public void preRender(int location, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, AXaeroMinimap modMain, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        ((WaypointGuiRenderContext)this.context).settings = modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).waypointBackgroundConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints = modMain.getSettings().deleteReachedDeathpoints;
        ((WaypointGuiRenderContext)this.context).scale = modMain.getSettings().waypointOnMapScale;
        Waypoint.RENDER_SORTING_POS = class_310.method_1551().field_1773.method_19418().method_19326();
        this.updateWaypointCollection(renderX, renderY, renderZ, modMain);
    }

    @Override
    public void postRender(int location, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, AXaeroMinimap modMain, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        renderTypeBuffers.method_22993();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), modMain.getSettings().renderAllSets);
    }

    public void updateWaypointCollection(double renderX, double renderY, double renderZ, AXaeroMinimap modMain) {
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        List<Waypoint> sortingList = ((WaypointGuiRenderContext)this.context).sortingList;
        sortingList.clear();
        if (waypointsManager.getWaypoints() != null) {
            if (modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        this.waypointReachDeleter.begin();
        ((WaypointGuiRenderContext)this.context).dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        ModSettings settings = modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).filterParams.setParams(renderX, renderY, renderZ, null, ((WaypointGuiRenderContext)this.context).dimDiv, settings.getDeathpoints(), settings.temporaryWaypointsGlobal, settings.getMaxWaypointsDistance(), settings.waypointsDistanceMin, 0.0, settings.dimensionScaledMaxWaypointDistance);
    }

    public void drawIconOnGUI(class_332 guiGraphics, MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY, class_4597.class_4598 renderTypeBuffer, class_4588 waypointBackgroundConsumer) {
        class_4587 matrixStack = guiGraphics.method_51448();
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        int initialsWidth = w.getWaypointType() == 1 ? 7 : class_310.method_1551().field_1772.method_1727(w.getSymbol());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5;
        rendererHelper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), waypointBackgroundConsumer, rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        if (w.getWaypointType() != 1) {
            Misc.drawNormalText(matrixStack, w.getSymbol(), (float)(drawX + 1 - initialsWidth / 2), (float)(drawY - 3), -1, true, renderTypeBuffer);
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
            RenderSystem.setShaderColor((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            GuiHelper.blit(matrixStack, rectX1 + 1, rectY1 + 1, 0.0f, 78.0f, 9, 9);
            RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            GuiHelper.blit(matrixStack, rectX1, rectY1, 0.0f, 78.0f, 9, 9);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, class_332 guiGraphics, class_1041 res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                class_4597.class_4598 textRenderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                Misc.drawCenteredPiercingText(guiGraphics.method_51448(), class_1074.method_4662((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), (float)(res.method_4486() / 2), (float)(res.method_4502() / 2 + 50), c, true, textRenderTypeBuffers);
                textRenderTypeBuffers.method_22993();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }

    @Override
    public boolean shouldRender(int location) {
        return (location != 1 && location != 0 || this.modMain.getSettings().getShowWaypoints()) && !class_310.method_1551().field_1724.method_6059(Effects.NO_WAYPOINTS) && !class_310.method_1551().field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final AXaeroMinimap modMain;

        private Builder(AXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointsGuiRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            WaypointGuiRenderContext context = new WaypointGuiRenderContext();
            context.filter = w -> {
                WaypointFilterParams filterParams = context.filterParams;
                boolean deathpoints = filterParams.deathpoints;
                if (w.isDisabled() || w.getVisibilityType() == 2 || w.getVisibilityType() == 3 || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                    return false;
                }
                double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
                double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
                double distanceScale = context.filterParams.dimensionScaleDistance ? class_310.method_1551().field_1687.method_8597().comp_646() : 1.0;
                double distance = Math.sqrt(offx * offx + offz * offz) * distanceScale;
                double waypointsDistance = filterParams.waypointsDistance;
                return w.isOneoffDestination() || w.getWaypointType() == 1 || w.isGlobal() || w.isTemporary() && filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance > waypointsDistance);
            };
            return new WaypointsGuiRenderer(this.modMain, new WaypointReader(), new WaypointRenderProvider(), context, this.waypointDeleter);
        }

        public static Builder begin(AXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

