/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.optifine_properties;

import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public class WeatherProperty
extends StringArrayOrRegexProperty {
    protected WeatherProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(WeatherProperty.readPropertiesOrThrow(properties, propertyNum, "weather"));
        if (this.ARRAY.contains((Object)"rain")) {
            this.ARRAY.add((Object)"thunder");
        }
    }

    public static WeatherProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new WeatherProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    @Nullable
    protected String getValueFromEntity(ETFEntity entity) {
        if (entity.getWorld() != null) {
            if (entity.getWorld().method_8546()) {
                return "thunder";
            }
            if (entity.getWorld().method_8419()) {
                return "rain";
            }
            return "clear";
        }
        return null;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return !ETFClientCommon.ETFConfigData.restrictWeather;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"weather"};
    }
}

