/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.optifine_properties;

import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.RangeFromStringArrayProperty;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public class TimeOfDayProperty
extends RangeFromStringArrayProperty<Long> {
    protected TimeOfDayProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(TimeOfDayProperty.readPropertiesOrThrow(properties, propertyNum, "dayTime"));
    }

    public static TimeOfDayProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new TimeOfDayProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected Long getRangeValueFromEntity(ETFEntity entity) {
        if (entity.getWorld() != null) {
            return entity.getWorld().method_8532();
        }
        return null;
    }

    @Override
    @Nullable
    protected RangeFromStringArrayProperty.RangeTester<Long> getRangeTesterFromString(String possibleRange) {
        try {
            if (possibleRange.matches("\\d-(\\d|-\\d)")) {
                String[] str = possibleRange.split("(?<!^|-)-");
                long small = Long.parseLong(str[0].replaceAll("[^0-9-]", ""));
                long big = Long.parseLong(str[1].replaceAll("[^0-9-]", ""));
                return value -> value >= small && value <= big;
            }
            long single = Long.parseLong(possibleRange.replaceAll("[^0-9-]", ""));
            return value -> value == single;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isPropertyUpdatable() {
        return !ETFClientCommon.ETFConfigData.restrictDayTime;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"dayTime"};
    }
}

