/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarning;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarnings;
import traben.entity_texture_features.texture_features.ETFManager;
import traben.entity_texture_features.texture_features.property_reading.RandomPropertiesFileHandler;
import traben.entity_texture_features.texture_features.property_reading.RandomPropertyRule;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.entity_wrappers.ETFBlockEntityWrapper;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntityWrapper;

public class ETFApi {
    public static final int ETFApiVersion = 7;
    @Deprecated
    public static ETFConfig getETFConfigObject = null;

    public static ETFConfig getETFConfigObject() {
        return ETFClientCommon.ETFConfigData;
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        ETFClientCommon.ETFConfigData = newETFConfig;
        ETFApi.saveETFConfigChangesAndResetETF();
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETFConfig.copyFrom(ETFClientCommon.ETFConfigData);
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETFUtils2.saveConfig();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        if (entity != null) {
            class_2960 etfIdentifier;
            ETFEntityWrapper etfEntity = new ETFEntityWrapper(entity);
            ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
            if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
                return etfIdentifier;
            }
        }
        return defaultTexture;
    }

    public static class_2960 getCurrentETFVariantTextureOfBlockEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, @Nullable Integer hashToAddToUUID) {
        if (entity != null) {
            class_2960 etfIdentifier;
            ETFBlockEntityWrapper etfEntity = new ETFBlockEntityWrapper(entity, hashToAddToUUID);
            ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.BLOCK_ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveBlockEntity);
            if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
                return etfIdentifier;
            }
        }
        return defaultTexture;
    }

    @Deprecated
    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, UUID ignore) {
        return ETFApi.getCurrentETFVariantTextureOfBlockEntity(entity, defaultTexture, ignore.hashCode());
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfBlockEntityOrNull(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, @Nullable Integer hashToAddToUUID) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, new ETFBlockEntityWrapper(entity, hashToAddToUUID), ETFManager.TextureSource.BLOCK_ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveBlockEntity)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static void renderETFEmissiveModel(@NotNull class_2586 entity, @Nullable Integer hashToAddToUUID, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFBlockEntityWrapper(entity, hashToAddToUUID), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_2586 entity, @Nullable Integer hashToAddToUUID, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFBlockEntityWrapper(entity, hashToAddToUUID), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static ETFRandomTexturePropertyInstance readRandomPropertiesFileAndReturnTestingObject3(class_2960 propertiesFileIdentifier, String ... suffixKeys) {
        return ETFRandomTexturePropertyInstance.getInstance(propertiesFileIdentifier, suffixKeys);
    }

    @Deprecated
    public static ETFRandomTexturePropertyInstance readRandomPropertiesFileAndReturnTestingObject2(class_2960 propertiesFileIdentifier, String suffixKey) {
        return ETFApi.readRandomPropertiesFileAndReturnTestingObject3(propertiesFileIdentifier, suffixKey);
    }

    public int getLastMatchingRuleOfEntity(class_1297 entity) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.get(entity.method_5667());
        return ruleIndex == null ? 0 : ruleIndex;
    }

    private int getLastMatchingRuleOfBlockEntity(class_2586 entity, @Nullable Integer hashToAddToUUID) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.get(ETFBlockEntityWrapper.getUUIDForBlockEntity(entity, hashToAddToUUID));
        return ruleIndex == null ? 0 : ruleIndex;
    }

    public void registerCustomRandomPropertyFactory(String yourModId, RandomProperties.RandomPropertyFactory ... factories) {
        if (factories != null && factories.length != 0) {
            RandomProperties.register(factories);
            ETFUtils2.logMessage(factories.length + " new ETF Random Properties registered by " + yourModId);
        }
    }

    public void registerCustomETFConfigWarning(String yourModId, ETFConfigWarning ... warnings) {
        if (warnings != null && warnings.length != 0) {
            ETFConfigWarnings.registerConfigWarning(warnings);
            ETFUtils2.logMessage(warnings.length + " new ETF Config Warnings registered by " + yourModId);
        }
    }

    public static class ETFRandomTexturePropertyInstance {
        protected final List<RandomPropertyRule> propertyCases;

        protected ETFRandomTexturePropertyInstance(List<RandomPropertyRule> etfs) {
            this.propertyCases = etfs;
        }

        @Nullable
        private static ETFRandomTexturePropertyInstance getInstance(class_2960 propertiesFileIdentifier, String ... suffixKeyName) {
            Properties props = ETFUtils2.readAndReturnPropertiesElseNull(propertiesFileIdentifier);
            if (props == null) {
                return null;
            }
            List<RandomPropertyRule> etfs = RandomPropertiesFileHandler.getAllValidPropertyObjects(props, propertiesFileIdentifier, suffixKeyName);
            if (etfs.isEmpty()) {
                return null;
            }
            return new ETFRandomTexturePropertyInstance(etfs);
        }

        public int getSuffixForEntity(class_1297 entityToBeTested, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            if (entityToBeTested == null) {
                return 0;
            }
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (RandomPropertyRule testCase : this.propertyCases) {
                ETFEntityWrapper entity;
                if (!testCase.doesEntityMeetConditionsOfThisCase(entity = new ETFEntityWrapper(entityToBeTested), isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getVariantSuffixFromThisCase(entity.getUuid());
            }
            return 0;
        }

        public int getSuffixForBlockEntity(class_2586 entityToBeTested, @Nullable Integer hashToAddToUUID, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            if (entityToBeTested == null) {
                return 0;
            }
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (RandomPropertyRule testCase : this.propertyCases) {
                ETFBlockEntityWrapper entity;
                if (!testCase.doesEntityMeetConditionsOfThisCase(entity = new ETFBlockEntityWrapper(entityToBeTested, hashToAddToUUID), isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getVariantSuffixFromThisCase(entity.getUuid());
            }
            return 0;
        }

        @Deprecated
        public int getSuffixForBlockEntity(class_2586 entityToBeTested, UUID uuidForBlockEntity, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            return this.getSuffixForBlockEntity(entityToBeTested, uuidForBlockEntity.hashCode(), isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain);
        }
    }
}

