/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Locale;
import java.util.Optional;

public enum PowerState {
    FOCUSED(false),
    HOVERED(true),
    UNFOCUSED(true),
    INVISIBLE(true),
    SUSPENDED(false);

    public final boolean configurable;
    public static final Codec<PowerState> CODEC;

    private PowerState(boolean configurable) {
        this.configurable = configurable;
    }

    static {
        CODEC = new PrimitiveCodec<PowerState>(){

            public <T> T write(DynamicOps<T> ops, PowerState value) {
                return (T)ops.createString(value.toString().toLowerCase(Locale.ROOT));
            }

            public <T> DataResult<PowerState> read(DynamicOps<T> ops, T input) {
                Optional value = ops.getStringValue(input).get().left();
                if (value.isEmpty()) {
                    return DataResult.error(() -> "Power state must not be empty!");
                }
                return DataResult.success((Object)((Object)PowerState.valueOf(((String)value.get()).toUpperCase(Locale.ROOT))));
            }
        };
    }
}

