/*
 * Decompiled with CFR 0.152.
 */
package opekope2.lilac.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import opekope2.lilac.annotation.EntrypointName;
import opekope2.lilac.exception.EntrypointException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Util {
    private Util() {
    }

    public static boolean checkModVersion(@NotNull String modId, @NotNull Function<Version, Boolean> predicate) {
        FabricLoader loader = FabricLoader.getInstance();
        Optional mod = loader.getModContainer(modId);
        if (mod.isEmpty()) {
            return false;
        }
        ModMetadata metadata = ((ModContainer)mod.get()).getMetadata();
        return predicate.apply(metadata.getVersion());
    }

    @Nullable
    public static StackTraceElement getStackTraceElementAt(int depth) {
        assert (depth >= 0);
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return depth + 2 >= trace.length ? null : trace[depth + 2];
    }

    @Nullable
    public static String getEntrypointName(@NotNull Class<?> type) {
        EntrypointName name = type.getAnnotation(EntrypointName.class);
        return name == null ? null : name.value();
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> getEntrypoints(@NotNull @NotNull Class<@NotNull T> type) {
        String name = Util.getEntrypointName(type);
        if (name == null) {
            throw new EntrypointException("`%s` is not annotated with `%s`".formatted(type.getName(), EntrypointName.class.getName()));
        }
        return FabricLoader.getInstance().getEntrypoints(name, type);
    }

    @NotNull
    public static <T> @NotNull List<EntrypointContainer<@NotNull T>> getEntrypointContainers(@NotNull @NotNull Class<@NotNull T> type) {
        String name = Util.getEntrypointName(type);
        if (name == null) {
            throw new EntrypointException("`%s` is not annotated with `%s`".formatted(type.getName(), EntrypointName.class.getName()));
        }
        return FabricLoader.getInstance().getEntrypointContainers(name, type);
    }
}

