/*
 * Decompiled with CFR 0.152.
 */
package opekope2.lilac.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tree {
    private Tree() {
    }

    public static final class Formatter {
        private final StringBuilder builder = new StringBuilder();
        private final Stack<Boolean> styles = new Stack<Boolean>(){
            private final BitSet bits = new BitSet();
            private int index = -1;

            @Override
            public Boolean push(Boolean item) {
                this.bits.set(++this.index, item);
                return item;
            }

            @Override
            public synchronized Boolean pop() {
                if (this.index < 0) {
                    throw new IndexOutOfBoundsException(this.index);
                }
                return this.bits.get(this.index--);
            }

            @Override
            public synchronized Boolean get(int index) {
                return this.bits.get(index);
            }

            @Override
            public synchronized int size() {
                return this.index + 1;
            }
        };

        private void indent(@NotNull Consumer<Formatter> function) {
            this.styles.push(true);
            function.accept(this);
            this.styles.pop();
        }

        private void appendNode(@NotNull Node node, boolean lastChild) {
            if (lastChild) {
                this.styles.pop();
                this.styles.push(false);
            }
            int size = this.styles.size();
            for (int i = 1; i < size - 1; ++i) {
                this.builder.append((Boolean)this.styles.get(i) != false ? "\u2502 " : "  ");
            }
            this.builder.append(this.styles.size() == 1 ? "" : (lastChild ? "\u2514\u2500" : "\u251c\u2500"));
            this.builder.append(node.text).append(System.lineSeparator());
        }

        private void append(@NotNull Node node, boolean lastChild) {
            this.indent(formatter -> {
                formatter.appendNode(node, lastChild);
                Iterator<Node> it = node.children.iterator();
                while (it.hasNext()) {
                    Node next = it.next();
                    boolean last = !it.hasNext();
                    this.append(next, last);
                }
            });
        }

        public static String format(@NotNull Node node) {
            Formatter formatter = new Formatter();
            formatter.append(node, true);
            return formatter.toString();
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static final class Node {
        @NotNull
        private final List<Node> _children = new ArrayList<Node>();
        @NotNull
        public final String text;
        @NotNull
        public final List<Node> children = Collections.unmodifiableList(this._children);

        public Node(@NotNull String text, @Nullable Node parent) {
            this.text = text;
            if (parent != null) {
                parent._children.add(this);
            }
        }

        public Node(@NotNull String text) {
            this(text, null);
        }

        @NotNull
        public Node appendChild(@NotNull String text) {
            return new Node(text, this);
        }

        public String toString() {
            return Formatter.format(this);
        }
    }
}

