/*
 * Decompiled with CFR 0.152.
 */
package opekope2.lilac.internal.fabric.mod_json;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.api.metadata.CustomValue;
import opekope2.lilac.api.ILilacApi;
import opekope2.lilac.api.dfu.IDataResultFactory;
import opekope2.lilac.api.fabric.mod_json.ICustomValueFactory;

public final class CustomValueOps
implements DynamicOps<CustomValue> {
    private static final ICustomValueFactory CUSTOM_VALUE_FACTORY = ILilacApi.getImplementation().getCustomValueFactory();
    private static final IDataResultFactory DATA_RESULT_FACTORY = IDataResultFactory.getInstance();
    public static CustomValueOps INSTANCE = new CustomValueOps();

    private CustomValueOps() {
    }

    private <R> DataResult<R> createConversionError(CustomValue input, String targetType) {
        return DATA_RESULT_FACTORY.error(() -> "Can't convert `%s` to `%s`".formatted(input.getType().name(), targetType));
    }

    public CustomValue empty() {
        return CUSTOM_VALUE_FACTORY.getNull();
    }

    public <U> U convertTo(DynamicOps<U> outOps, CustomValue input) {
        return (U)(switch (input.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CustomValue.CvType.OBJECT -> this.convertMap(outOps, input);
            case CustomValue.CvType.ARRAY -> this.convertList(outOps, input);
            case CustomValue.CvType.STRING -> outOps.createString(input.getAsString());
            case CustomValue.CvType.NUMBER -> outOps.createNumeric(input.getAsNumber());
            case CustomValue.CvType.BOOLEAN -> outOps.createBoolean(input.getAsBoolean());
            case CustomValue.CvType.NULL -> outOps.empty();
        });
    }

    public DataResult<Number> getNumberValue(CustomValue input) {
        return input.getType() == CustomValue.CvType.NUMBER ? DATA_RESULT_FACTORY.success(input.getAsNumber()) : this.createConversionError(input, "Number");
    }

    public CustomValue createNumeric(Number i) {
        return CUSTOM_VALUE_FACTORY.createNumber(i);
    }

    public DataResult<String> getStringValue(CustomValue input) {
        return input.getType() == CustomValue.CvType.STRING ? DATA_RESULT_FACTORY.success(input.getAsString()) : this.createConversionError(input, "String");
    }

    public CustomValue createString(String value) {
        return CUSTOM_VALUE_FACTORY.createString(value);
    }

    public DataResult<Boolean> getBooleanValue(CustomValue input) {
        return input.getType() == CustomValue.CvType.BOOLEAN ? DATA_RESULT_FACTORY.success(input.getAsBoolean()) : this.createConversionError(input, "Boolean");
    }

    public CustomValue createBoolean(boolean value) {
        return CUSTOM_VALUE_FACTORY.createBoolean(value);
    }

    public DataResult<CustomValue> mergeToList(CustomValue list, CustomValue value) {
        if (list.getType() != CustomValue.CvType.ARRAY && list != this.empty()) {
            return DATA_RESULT_FACTORY.error(() -> "Can't merge into `%s` (should be array)".formatted(list.getType().name()));
        }
        ArrayList<CustomValue> l = new ArrayList<CustomValue>();
        if (list != this.empty()) {
            list.getAsArray().forEach(l::add);
        }
        l.add(value);
        return DATA_RESULT_FACTORY.success(CUSTOM_VALUE_FACTORY.createArray((CustomValue[])l.toArray(CustomValue[]::new)));
    }

    public DataResult<CustomValue> mergeToMap(CustomValue map, CustomValue key, CustomValue value) {
        if (map.getType() != CustomValue.CvType.OBJECT && map != this.empty()) {
            return DATA_RESULT_FACTORY.error(() -> "Can't merge into `%s` (should be object)".formatted(map.getType().name()));
        }
        if (key.getType() != CustomValue.CvType.STRING) {
            return DATA_RESULT_FACTORY.error(() -> "Key is `%s` (should be string)".formatted(key.getType().name()));
        }
        HashMap<String, CustomValue> m = new HashMap<String, CustomValue>();
        if (map != this.empty()) {
            map.getAsObject().forEach(pair -> m.put((String)pair.getKey(), (CustomValue)pair.getValue()));
        }
        m.put(key.getAsString(), value);
        return DATA_RESULT_FACTORY.success(CUSTOM_VALUE_FACTORY.createObject(m));
    }

    public DataResult<Stream<Pair<CustomValue, CustomValue>>> getMapValues(CustomValue input) {
        return input.getType() == CustomValue.CvType.OBJECT ? DATA_RESULT_FACTORY.success(StreamSupport.stream(input.getAsObject().spliterator(), false).map(pair -> new Pair((Object)this.createString((String)pair.getKey()), (Object)((CustomValue)pair.getValue())))) : this.createConversionError(input, "Map");
    }

    public CustomValue createMap(Stream<Pair<CustomValue, CustomValue>> map) {
        return CUSTOM_VALUE_FACTORY.createObject(map.collect(Collectors.toMap(pair -> ((CustomValue)pair.getFirst()).getAsString(), Pair::getSecond)));
    }

    public DataResult<Stream<CustomValue>> getStream(CustomValue input) {
        return input.getType() == CustomValue.CvType.ARRAY ? DATA_RESULT_FACTORY.success(StreamSupport.stream(input.getAsArray().spliterator(), false)) : DATA_RESULT_FACTORY.error(() -> "Can't convert `%s` to Stream (should be array)".formatted(input.getType().name()));
    }

    public CustomValue createList(Stream<CustomValue> input) {
        return CUSTOM_VALUE_FACTORY.createArray((CustomValue[])input.toArray(CustomValue[]::new));
    }

    public CustomValue remove(CustomValue input, String key) {
        if (input.getType() == CustomValue.CvType.OBJECT) {
            HashMap<String, CustomValue> m = new HashMap<String, CustomValue>();
            StreamSupport.stream(input.getAsObject().spliterator(), false).filter(pair -> !Objects.equals(pair.getKey(), key)).forEach(pair -> m.put((String)pair.getKey(), (CustomValue)pair.getValue()));
            return CUSTOM_VALUE_FACTORY.createObject(m);
        }
        return input;
    }
}

