/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.util;

import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.quiltmc.loader.api.minecraft.ClientOnly;

@ClientOnly
public final class LBGTextureGenerator
extends Enum<LBGTextureGenerator> {
    private static final class_2960 FALLBACK_TEXTURE;
    private static final /* synthetic */ LBGTextureGenerator[] $VALUES;

    public static LBGTextureGenerator[] values() {
        return (LBGTextureGenerator[])$VALUES.clone();
    }

    public static LBGTextureGenerator valueOf(String name) {
        return Enum.valueOf(LBGTextureGenerator.class, name);
    }

    private static class_1011 getFallbackNativeImage(class_3300 resourceManager) {
        try {
            class_3298 fallbackResource = resourceManager.getResourceOrThrow(FALLBACK_TEXTURE);
            return class_1011.method_4309((InputStream)fallbackResource.method_14482());
        }
        catch (IOException e) {
            LambdaBetterGrass.get().warn("Could not load fallback texture \"" + FALLBACK_TEXTURE + "\"!");
            return new class_1011(16, 16, false);
        }
    }

    public static class_1011 getNativeImage(class_3300 resourceManager, class_2960 path) {
        try {
            class_3298 nativeImageResource = resourceManager.getResourceOrThrow(path);
            return class_1011.method_4309((InputStream)nativeImageResource.method_14482());
        }
        catch (IOException e) {
            LambdaBetterGrass.get().warn("Could not load texture \"" + path + "\"! Exception: " + e.getMessage() + ". Loading fallback texture instead.");
            return LBGTextureGenerator.getFallbackNativeImage(resourceManager);
        }
    }

    public static class_1011 mirrorImage(class_1011 source) {
        class_1011 result = new class_1011(source.method_4307(), source.method_4323(), false);
        for (int y = 0; y < result.method_4323(); ++y) {
            for (int x = 0; x < result.method_4307(); ++x) {
                result.method_4305(source.method_4307() - 1 - x, y, source.method_4315(x, y));
            }
        }
        return result;
    }

    public static class_2960 generateTexture(String target, class_1011 side, class_1011 top, class_1011 mask) {
        class_1011 image = LBGTextureGenerator.applyMask(side, top, mask);
        return LambdaBetterGrass.get().resourcePack.dynamicallyPutImage(target, image);
    }

    public static class_1011 applyMask(class_1011 source, class_1011 top, class_1011 mask) {
        int width = Math.max(Math.max(source.method_4307(), top.method_4307()), mask.method_4307());
        int height = Math.max(Math.max(source.method_4323(), top.method_4323()), mask.method_4323());
        class_1011 output = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int sourceRGB = source.method_4315(LBGTextureGenerator.getTrueCoordinate(width, source.method_4307(), x), LBGTextureGenerator.getTrueCoordinate(height, source.method_4323(), y));
                int topRGB = top.method_4315(LBGTextureGenerator.getTrueCoordinate(width, top.method_4307(), x), LBGTextureGenerator.getTrueCoordinate(height, top.method_4323(), y));
                if (mask.method_4311(LBGTextureGenerator.getTrueCoordinate(width, mask.method_4307(), x), LBGTextureGenerator.getTrueCoordinate(height, mask.method_4323(), y)) == -1) {
                    output.method_4305(x, y, topRGB);
                    continue;
                }
                output.method_4305(x, y, sourceRGB);
            }
        }
        return output;
    }

    private static int getTrueCoordinate(int resolution, int targetResolution, int coordinate) {
        if (resolution == targetResolution) {
            return coordinate;
        }
        return (int)((double)coordinate / (double)resolution * (double)targetResolution);
    }

    private static /* synthetic */ LBGTextureGenerator[] $values() {
        return new LBGTextureGenerator[0];
    }

    static {
        $VALUES = LBGTextureGenerator.$values();
        FALLBACK_TEXTURE = LambdaBetterGrass.id("textures/block/transparent.png");
    }
}

