/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerType;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_790;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class LBGResourceReloader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void reload(class_3300 resourceManager) {
        LBGState.reset();
        LBGLayerType.reset();
        Map layerTypes = resourceManager.method_14488("bettergrass/layer_types", path -> path.method_12832().endsWith(".json"));
        layerTypes.forEach(LBGLayerType::load);
        this.loadStates(resourceManager);
    }

    private void loadStates(class_3300 resourceManager) {
        class_790.class_791 variantMapDeserializationContext = new class_790.class_791();
        resourceManager.method_14488("bettergrass/states", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> this.loadState(resourceManager, (class_2960)id, (class_3298)resource, variantMapDeserializationContext));
    }

    private void loadState(class_3300 resourceManager, class_2960 id, class_3298 resource, class_790.class_791 variantMapDeserializationContext) {
        class_2960 stateId = new class_2960(id.method_12836(), id.method_12832().substring("bettergrass/states".length() + 1, id.method_12832().length() - ".json".length()));
        Optional block = class_7923.field_41175.method_17966(stateId);
        if (block.isEmpty()) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            LBGState.loadMetadataState(stateId, (class_2248)block.get(), resourceManager, json, variantMapDeserializationContext);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load LambdaBetterGrass state {}.", (Object)stateId, (Object)e);
        }
    }
}

