/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.model;

import dev.lambdaurora.lambdabettergrass.LBGMode;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayer;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.util.LayeredBlockUtils;
import it.unimi.dsi.fastutil.ints.Int2BooleanFunction;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class LBGBakedModel
extends ForwardingBakedModel {
    private final LBGMetadata metadata;

    public LBGBakedModel(class_1087 baseModel, LBGMetadata metadata) {
        this.wrapped = baseModel;
        this.metadata = metadata;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2960 blockId;
        class_2960 stateId;
        class_2338 upPos;
        class_2680 up;
        LBGMode mode = LambdaBetterGrass.get().config.getMode();
        if (mode == LBGMode.OFF) {
            super.emitBlockQuads(world, state, pos, randomSupplier, context);
            return;
        }
        if (this.metadata.getSnowyModelVariant() != null && LambdaBetterGrass.get().hasBetterLayer() && state.method_28501().contains(class_2741.field_12512) && !((Boolean)state.method_11654((class_2769)class_2741.field_12512)).booleanValue() && !(up = world.method_8320(upPos = pos.method_10084())).method_26215() && LayeredBlockUtils.shouldGrassBeSnowy(world, pos, stateId = new class_2960((blockId = class_7923.field_41175.method_10221((Object)up.method_26204())).method_12836(), blockId.method_12832()), up, false)) {
            this.metadata.getSnowyModelVariant().emitBlockQuads(world, (class_2680)state.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)), pos, randomSupplier, context);
            return;
        }
        context.pushTransform(quad -> {
            if (LBGBakedModel.canEditQuad((QuadView)quad)) {
                this.metadata.getLayer(quad.colorIndex()).ifPresent(layer -> {
                    boolean leftMatch;
                    if (mode == LBGMode.FASTEST) {
                        LBGBakedModel.spriteBake(quad, layer, "connect");
                        return;
                    }
                    class_2350 face = quad.nominalFace();
                    class_2350 right = face.method_10170();
                    class_2350 left = face.method_10160();
                    if (LBGBakedModel.canFullyConnect(world, state, pos, face) && LBGBakedModel.spriteBake(quad, layer, "connect")) {
                        return;
                    }
                    if (mode != LBGMode.FANCY) {
                        return;
                    }
                    boolean rightMatch = LBGBakedModel.canConnect(world, state, pos.method_10074(), right) || LBGBakedModel.canConnect(world, state, pos, right) && LBGBakedModel.canFullyConnect(world, state, pos.method_10093(right), face);
                    boolean bl = leftMatch = LBGBakedModel.canConnect(world, state, pos.method_10074(), left) || LBGBakedModel.canConnect(world, state, pos, left) && LBGBakedModel.canFullyConnect(world, state, pos.method_10093(left), face);
                    if (rightMatch && leftMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "arch");
                    } else if (rightMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "blend_up_m");
                    } else if (leftMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "blend_up");
                    }
                });
            }
            return true;
        });
        super.emitBlockQuads(world, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private static boolean canEditQuad(QuadView quad) {
        if (quad.nominalFace().method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        if (LBGBakedModel.testAll(i -> quad.y(i) > 1.0f || quad.y(i) < 0.0f)) {
            return false;
        }
        if (quad.nominalFace().method_10166() == class_2350.class_2351.field_11048) {
            return !LBGBakedModel.testAll(i -> quad.z(i) != 0.0f) || !LBGBakedModel.testAll(i -> quad.z(i) != 1.0f);
        }
        if (quad.nominalFace().method_10166() == class_2350.class_2351.field_11051) {
            return !LBGBakedModel.testAll(i -> quad.x(i) != 0.0f) || !LBGBakedModel.testAll(i -> quad.x(i) != 1.0f);
        }
        return true;
    }

    private static boolean testAll(Int2BooleanFunction tester) {
        for (int i = 0; i < 4; ++i) {
            if (tester.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean canFullyConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2350 direction) {
        return LBGBakedModel.canConnect(world, self, selfPos, selfPos.method_10093(direction).method_10074());
    }

    private static boolean canConnect(class_1920 world, class_2680 self, class_2338 start, class_2350 direction) {
        return LBGBakedModel.canConnect(world, self, start, start.method_10093(direction));
    }

    private static boolean canConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2338 adjacentPos) {
        boolean selfSnowy;
        class_2680 adjacent = world.method_8320(adjacentPos);
        class_2338 upPos = adjacentPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        if (LambdaBetterGrass.get().hasBetterLayer() && self.method_26204() instanceof class_2493 && (selfSnowy = ((Boolean)self.method_11654((class_2769)class_2741.field_12512)).booleanValue()) && !up.method_26215()) {
            class_2960 blockId;
            class_2960 stateId;
            if (up.method_27852(class_2246.field_10477)) {
                return true;
            }
            if (adjacent.method_26204() instanceof class_2493 && LayeredBlockUtils.shouldGrassBeSnowy(world, adjacentPos, stateId = new class_2960((blockId = class_7923.field_41175.method_10221((Object)up.method_26204())).method_12836(), "bettergrass/states/" + blockId.method_12832()), up, true)) {
                return true;
            }
        }
        return LBGBakedModel.canConnect(self, adjacent) && (up.method_26215() || !up.method_26206((class_1922)world, upPos, class_2350.field_11033));
    }

    private static boolean canConnect(class_2680 self, class_2680 adjacent) {
        return self == adjacent;
    }

    private static boolean spriteBake(MutableQuadView quad, LBGLayer layer, String texture) {
        class_1058 sprite = layer.getBakedTexture(texture);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
        return sprite != null;
    }
}

