/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;

public final class MigrationNotice
implements PreLaunchEntrypoint {
    private final JFrame frame = new JFrame("LambdaBetterGrass Migration Notice");
    private final Image iconImage = MigrationNotice.rescaled(ImageIO.read(Objects.requireNonNull(MigrationNotice.class.getResource("/assets/lambdabettergrass/icon.png"))), 4.0);
    private final Icon icon = new ImageIcon(this.iconImage);

    public void onPreLaunch() {
        JScrollPane scrollPane = new JScrollPane(this.makeTextPanel(), 20, 31);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)scrollPane, "Center");
        JPanel buttons = new JPanel();
        JButton goToQuiltButton = new JButton("Install Quilt");
        goToQuiltButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://quiltmc.org/en/install/"));
            }
            catch (IOException | UnsupportedOperationException ex) {
                JOptionPane.showMessageDialog(this.frame, "It seems there's difficulty in opening the browser. Please copy and open this link: https://quiltmc.org/en/install/", "Failed to open link in browser", 2, this.icon);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        });
        buttons.add(goToQuiltButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(e -> this.frame.dispose());
        buttons.add(closeButton);
        panel.add((Component)buttons, "South");
        this.frame.setContentPane(panel);
        this.frame.setIconImage(this.iconImage);
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.setMaximumSize(new Dimension(900, 700));
        this.frame.setMaximizedBounds(new Rectangle(900, 700));
        this.frame.setDefaultCloseOperation(3);
    }

    private JComponent makeTextPanel() {
        JTextPane textArea = new JTextPane();
        textArea.setContentType("text/html");
        textArea.setText("<html>\n<h1>LambdaBetterGrass is moving to Quilt!</h1>\n<p>You heard right, the mod is moving to the <a href=\"https://quiltmc.org/\">Quilt</a> mod loader.</p>\n<br />\n<h3>Why move to Quilt?</h3>\n<p>This mod is heavily relying on modifying resource loading mechanics, mostly by injecting dynamically generated resources.\nMinecraft 1.19.3 came around, despite not being the most feature-filled for users, it's filled with refactors, including stuff touching resource loading.</p>\n<p>For my mods, despite being directly involved with Quilt's development, I have decided to keep using Fabric as long as it's not a burden.\nBut with those resource loading refactors, the port burden was very high, and Quilt now has the resource loading APIs I need for this mod.\nWhich is why I moved this mod to it, to ease the port to 1.19.3 and hopefully reduce maintenance burden in the future.</p>\n<p>As a bonus, moving to Quilt also fixes the default resource pack being enabled on first installation, which was intended but not working on Fabric\ndue to it not being fully implemented.</p>\n<br />\n<h3>Can I still use the mod with Fabric mods?</h3>\n<p>Yes, absolutely!</p>\n<p>It's one of the big advantages of Quilt, mods switching to it can benefit greatly from the new APIs while letting the users continue to use\ntheir favorite Fabric mods alongside.</p>\n<br />\n<h3>What about CurseForge modpacks?</h3>\n<p>CurseForge not having support for Quilt modpacks at the time of writing, a forgotten mod has been dusted off and adapted to allow\nthe usage of Quilt in CurseForge modpacks.<br/>\nIndeed, the remnants of JumpLoader have been picked up to become <a href=\"https://www.curseforge.com/minecraft/mc-mods/jumpquilt\">JumpQuilt</a>.</p>\n<br />\n<h3>Having challenges getting Quilt working?</h3>\n<p>Feel free to join the <a href=\"https://discord.quiltmc.org/\">Quilt Discord</a> or the <a href=\"https://forum.quiltmc.org/\">Quilt Forum</a>\nto get support from experienced users and developers.</p>\n<p>Having trouble with LambdaBetterGrass specifically? Feel free <a href=\"https://github.com/LambdAurora/LambdaBetterGrass/issues\">to make an issue</a>\nor join my <a href=\"https://discord.gg/abEbzzv\">Discord guild</a>.</p>\n</html>\n");
        textArea.setEditable(false);
        textArea.addHyperlinkListener(e -> {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            try {
                Desktop.getDesktop().browse(e.getURL().toURI());
            }
            catch (IOException | UnsupportedOperationException ex) {
                JOptionPane.showMessageDialog(this.frame, "It seems there's difficulty in opening the browser. Please copy and open this link: " + e.getURL().toString(), "Failed to open link in browser", 2, this.icon);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        });
        return textArea;
    }

    private static BufferedImage rescaled(BufferedImage im, double factor) {
        AffineTransform xform = AffineTransform.getScaleInstance(factor, factor);
        return new AffineTransformOp(xform, 1).filter(im, null);
    }

    static {
        if (System.getProperty("awt.useSystemAAFontSettings") == null) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
        }
        if (System.getProperty("swing.aatext") == null) {
            System.setProperty("swing.aatext", "true");
        }
    }
}

