/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.waveycapes.CapeMovement;
import dev.tr7zw.waveycapes.CapeStyle;
import dev.tr7zw.waveycapes.WindMode;
import dev.tr7zw.waveycapes.config.Config;
import dev.tr7zw.waveycapes.config.ConfigUpgrader;
import dev.tr7zw.waveycapes.config.CustomConfigScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7172;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class WaveyCapesBase {
    public static WaveyCapesBase INSTANCE;
    public static final Logger LOGGER;
    public static Config config;
    private final File settingsFile = new File("config", "waveycapes.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void init() {
        INSTANCE = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(config)) {
            this.writeConfig();
        }
        this.initSupportHooks();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.wc.title"){
            private int rotationX;
            private int rotationY;
            {
                this.rotationX = 164;
                this.rotationY = 5;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.wc.setting.capestyle", CapeStyle.class, () -> WaveyCapesBase.config.capeStyle, v -> {
                    WaveyCapesBase.config.capeStyle = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.windmode", WindMode.class, () -> WaveyCapesBase.config.windMode, v -> {
                    WaveyCapesBase.config.windMode = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.capemovement", CapeMovement.class, () -> WaveyCapesBase.config.capeMovement, v -> {
                    WaveyCapesBase.config.capeMovement = v;
                }));
                options.add(this.getIntOption("text.wc.setting.gravity", 5, 32, () -> WaveyCapesBase.config.gravity, v -> {
                    WaveyCapesBase.config.gravity = v;
                }));
                options.add(this.getIntOption("text.wc.setting.heightMultiplier", 4, 16, () -> WaveyCapesBase.config.heightMultiplier, v -> {
                    WaveyCapesBase.config.heightMultiplier = v;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                WaveyCapesBase.this.writeConfig();
            }

            public boolean method_25404(int i, int j, int k) {
                if (i == 263) {
                    --this.rotationX;
                }
                if (i == 262) {
                    ++this.rotationX;
                }
                if (i == 264) {
                    --this.rotationY;
                }
                if (i == 265) {
                    ++this.rotationY;
                }
                return super.method_25404(i, j, k);
            }

            @Override
            public void method_25394(class_332 guiGraphics, int xMouse, int yMouse, float f) {
                super.method_25394(guiGraphics, xMouse, yMouse, f);
                if (this.field_22787.field_1687 != null) {
                    int x = this.field_22787.method_22683().method_4486() / 2;
                    int y = this.field_22787.method_22683().method_4502() - this.field_22787.method_22683().method_4502() / 3;
                    int size = (int)(40.0f * ((float)this.field_22787.method_22683().method_4502() / 200.0f));
                    WaveyCapesBase.this.drawEntity(x, y, size, this.rotationX, this.rotationY, (class_1309)this.field_22787.field_1724, f);
                }
            }

            @Override
            public void reset() {
                config = new Config();
                WaveyCapesBase.this.writeConfig();
            }
        };
        return screen;
    }

    private void drawEntity(int x, int y, int size, float lookX, float lookY, class_1309 livingEntity, float delta) {
        float rotationModifyer = 3.0f;
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904(0.0, 1.0, 1000.0);
        matrixStack.method_22905((float)size, (float)size, (float)size);
        Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf quaternion2 = class_7833.field_40714.rotationDegrees(lookY * rotationModifyer);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.method_22907(quaternion);
        matrixStack.method_22904(0.0, -1.0, 0.0);
        float yBodyRot = livingEntity.field_6283;
        float yRot = livingEntity.method_36454();
        float yRotO = livingEntity.field_5982;
        float yBodyRotO = livingEntity.field_6220;
        float xRot = livingEntity.method_36455();
        float xRotO = livingEntity.field_6004;
        float yHeadRotO = livingEntity.field_6259;
        float yHeadRot = livingEntity.field_6241;
        class_243 vel = livingEntity.method_18798();
        livingEntity.field_6283 = 180.0f + lookX * rotationModifyer;
        livingEntity.method_36456(180.0f + lookX * rotationModifyer);
        livingEntity.field_6220 = livingEntity.field_6283;
        livingEntity.field_5982 = livingEntity.method_36454();
        livingEntity.method_18799(class_243.field_1353);
        livingEntity.method_36457(0.0f);
        livingEntity.field_6004 = livingEntity.method_36455();
        livingEntity.field_6241 = livingEntity.method_36454();
        livingEntity.field_6259 = livingEntity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternion2.conjugate();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        entityRenderDispatcher.method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, delta, matrixStack, (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        livingEntity.field_6283 = yBodyRot;
        livingEntity.field_6220 = yBodyRotO;
        livingEntity.method_36456(yRot);
        livingEntity.field_5982 = yRotO;
        livingEntity.method_36457(xRot);
        livingEntity.field_6004 = xRotO;
        livingEntity.field_6259 = yHeadRotO;
        livingEntity.field_6241 = yHeadRot;
        livingEntity.method_18799(vel);
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public abstract void initSupportHooks();

    protected static boolean doesClassExist(String name) {
        try {
            if (Class.forName(name) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        LOGGER = LogManager.getLogger((String)"WaveyCapes");
    }
}

