/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import dev.tr7zw.waveycapes.CapeMovement;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.math.Vector3;
import dev.tr7zw.waveycapes.sim.BasicSimulation;
import dev.tr7zw.waveycapes.sim.StickSimulation;
import dev.tr7zw.waveycapes.sim.StickSimulation3d;
import dev.tr7zw.waveycapes.sim.StickSimulationDungeons;
import net.minecraft.class_3532;
import net.minecraft.class_742;

public interface CapeHolder {
    public BasicSimulation getSimulation();

    public void setSimulation(BasicSimulation var1);

    default public void updateSimulation(class_742 abstractClientPlayer, int partCount) {
        BasicSimulation simulation = this.getSimulation();
        if (simulation == null || this.incorrectSimulation(simulation)) {
            simulation = this.createSimulation();
            this.setSimulation(simulation);
        }
        if (simulation == null) {
            return;
        }
        boolean dirty = simulation.init(partCount);
        if (dirty) {
            simulation.applyMovement(new Vector3(1.0f, 1.0f, 0.0f));
            for (int i = 0; i < 5; ++i) {
                this.simulate(abstractClientPlayer);
            }
        }
    }

    default public boolean incorrectSimulation(BasicSimulation sim) {
        CapeMovement style = WaveyCapesBase.config.capeMovement;
        if (style == CapeMovement.BASIC_SIMULATION && sim.getClass() != StickSimulation.class) {
            return true;
        }
        if (style == CapeMovement.BASIC_SIMULATION_3D && sim.getClass() != StickSimulation3d.class) {
            return true;
        }
        return style == CapeMovement.DUNGEONS && sim.getClass() != StickSimulationDungeons.class;
    }

    default public BasicSimulation createSimulation() {
        CapeMovement style = WaveyCapesBase.config.capeMovement;
        if (style == CapeMovement.BASIC_SIMULATION) {
            return new StickSimulation();
        }
        if (style == CapeMovement.BASIC_SIMULATION_3D) {
            return new StickSimulation3d();
        }
        if (style == CapeMovement.DUNGEONS) {
            return new StickSimulationDungeons();
        }
        return null;
    }

    default public void simulate(class_742 abstractClientPlayer) {
        BasicSimulation simulation = this.getSimulation();
        if (simulation == null || simulation.empty()) {
            return;
        }
        double d = abstractClientPlayer.field_7500 - abstractClientPlayer.method_23317();
        double m = abstractClientPlayer.field_7499 - abstractClientPlayer.method_23321();
        float n = abstractClientPlayer.field_6220 + abstractClientPlayer.field_6283 - abstractClientPlayer.field_6220;
        double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
        double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
        float heightMul = WaveyCapesBase.config.heightMultiplier;
        float straveMul = WaveyCapesBase.config.straveMultiplier;
        if (abstractClientPlayer.method_5869()) {
            heightMul *= 2.0f;
        }
        double fallHack = class_3532.method_15350((double)((abstractClientPlayer.field_6036 - abstractClientPlayer.method_23318()) * 10.0), (double)0.0, (double)1.0);
        if (abstractClientPlayer.method_5869()) {
            simulation.setGravity((float)WaveyCapesBase.config.gravity / 10.0f);
        } else {
            simulation.setGravity(WaveyCapesBase.config.gravity);
        }
        Vector3 gravity = new Vector3(0.0f, -1.0f, 0.0f);
        StickSimulation.Vector2 strave = new StickSimulation.Vector2((float)(abstractClientPlayer.method_23317() - abstractClientPlayer.field_6014), (float)(abstractClientPlayer.method_23321() - abstractClientPlayer.field_5969));
        strave.rotateDegrees(-abstractClientPlayer.method_36454());
        double changeX = d * o + m * p + fallHack + (double)(abstractClientPlayer.method_18276() && !simulation.isSneaking() ? 3 : 0);
        double changeY = (abstractClientPlayer.method_23318() - abstractClientPlayer.field_6036) * (double)heightMul + (double)(abstractClientPlayer.method_18276() && !simulation.isSneaking() ? 1 : 0);
        double changeZ = -strave.x * straveMul;
        simulation.setSneaking(abstractClientPlayer.method_18276());
        Vector3 change = new Vector3((float)changeX, (float)changeY, (float)changeZ);
        if (abstractClientPlayer.method_20232()) {
            float rotation = abstractClientPlayer.method_36455();
            gravity.rotateDegrees(rotation += 90.0f);
            change.rotateDegrees(rotation);
        }
        simulation.setGravityDirection(gravity);
        simulation.applyMovement(change);
        simulation.simulate();
    }
}

